/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.wallet;

import io.github.lightman314.lightmanscurrency.common.menus.wallet.WalletMenuBase;
import io.github.lightman314.lightmanscurrency.network.packet.ClientToServerPacket;
import io.github.lightman314.lightmanscurrency.network.packet.CustomPacket;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class CPacketOpenWallet
extends ClientToServerPacket {
    private static final CustomPacketPayload.Type<CPacketOpenWallet> TYPE = new CustomPacketPayload.Type(VersionUtil.lcResource("c_wallet_open"));
    public static final CustomPacket.Handler<CPacketOpenWallet> HANDLER = new H();
    private final int walletStackIndex;

    public CPacketOpenWallet(int walletStackIndex) {
        super(TYPE);
        this.walletStackIndex = walletStackIndex;
    }

    public static void sendEquippedPacket() {
        new CPacketOpenWallet(-1).send();
    }

    private static void encode(@Nonnull FriendlyByteBuf buffer, @Nonnull CPacketOpenWallet message) {
        buffer.writeInt(message.walletStackIndex);
    }

    private static CPacketOpenWallet decode(@Nonnull FriendlyByteBuf buffer) {
        return new CPacketOpenWallet(buffer.readInt());
    }

    private static class H
    extends CustomPacket.Handler<CPacketOpenWallet> {
        protected H() {
            super(TYPE, CustomPacket.easyCodec(CPacketOpenWallet::encode, CPacketOpenWallet::decode));
        }

        @Override
        protected void handle(@Nonnull CPacketOpenWallet message, @Nonnull IPayloadContext context, @Nonnull Player player) {
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                WalletMenuBase.SafeOpenWalletMenu((Player)sp, message.walletStackIndex);
            }
        }
    }
}

