/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.capability.variant;

import com.google.common.collect.ImmutableList;
import io.github.lightman314.lightmanscurrency.api.misc.blocks.IDeepBlock;
import io.github.lightman314.lightmanscurrency.api.misc.blocks.ITallBlock;
import io.github.lightman314.lightmanscurrency.api.misc.blocks.IWideBlock;
import io.github.lightman314.lightmanscurrency.api.variants.block.block_entity.IVariantDataStorage;
import io.github.lightman314.lightmanscurrency.api.variants.block.builtin.VariantChunkDataStorageAttachment;
import io.github.lightman314.lightmanscurrency.api.variants.block.builtin.VariantDataStorageAttachment;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.level.ChunkWatchEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber
public class CapabilityVariantData {
    public static final Capability<IVariantDataStorage> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IVariantDataStorage>(){});
    private static final Set<BlockEntityType<?>> AUTO_BLOCK_ENTITIES = new ObjectArraySet();
    private static final Map<ResourceLocation, BiFunction<BlockState, BlockPos, BlockPos>> AUTO_BLOCKS = new HashMap<ResourceLocation, BiFunction<BlockState, BlockPos, BlockPos>>();

    public static void registerBlockEntity(BlockEntityType<?> ... types) {
        AUTO_BLOCK_ENTITIES.addAll((Collection<BlockEntityType<?>>)ImmutableList.copyOf((Object[])types));
    }

    public static void registerNormalBlock(Block ... blocks) {
        CapabilityVariantData.registerMultiBlock((s, p) -> p, blocks);
    }

    public static void registerLCMultiBlock(Block ... blocks) {
        CapabilityVariantData.registerMultiBlock((state, pos) -> {
            IDeepBlock deep;
            IWideBlock wide;
            ITallBlock tall;
            Block b = state.m_60734_();
            if (b instanceof ITallBlock && (tall = (ITallBlock)b).getIsTop((BlockState)state)) {
                pos = tall.getOtherHeight((BlockPos)pos, (BlockState)state);
            }
            if (b instanceof IWideBlock && (wide = (IWideBlock)b).getIsRight((BlockState)state)) {
                pos = wide.getOtherSide((BlockPos)pos, (BlockState)state);
            }
            if (b instanceof IDeepBlock && (deep = (IDeepBlock)b).getIsBack((BlockState)state)) {
                pos = deep.getOtherDepth((BlockPos)pos, (BlockState)state);
            }
            return pos;
        }, blocks);
    }

    public static void registerMultiBlock(BiFunction<BlockState, BlockPos, BlockPos> getMultiblockCorner, Block ... blocks) {
        for (Block b : blocks) {
            AUTO_BLOCKS.put(ForgeRegistries.BLOCKS.getKey((Object)b), getMultiblockCorner);
        }
    }

    @ApiStatus.Internal
    @Nullable
    public static BlockPos getBlockCorner(BlockState state, BlockPos pos) {
        ResourceLocation id = ForgeRegistries.BLOCKS.getKey((Object)state.m_60734_());
        if (AUTO_BLOCKS.containsKey(id)) {
            return AUTO_BLOCKS.get(id).apply(state, pos);
        }
        return null;
    }

    @SubscribeEvent
    @ApiStatus.Internal
    public static void onBlockEntityCaps(AttachCapabilitiesEvent<BlockEntity> event) {
        if (AUTO_BLOCK_ENTITIES.contains(((BlockEntity)event.getObject()).m_58903_())) {
            event.addCapability(VersionUtil.lcResource("variant_data"), (ICapabilityProvider)new VariantDataStorageAttachment((BlockEntity)event.getObject()));
        }
    }

    @SubscribeEvent
    @ApiStatus.Internal
    public static void onChunkCaps(AttachCapabilitiesEvent<LevelChunk> event) {
        event.addCapability(VersionUtil.lcResource("variant_chunk_data"), (ICapabilityProvider)new VariantChunkDataStorageAttachment((LevelChunk)event.getObject()));
    }

    @SubscribeEvent
    @ApiStatus.Internal
    public static void onChunkLoad(ChunkWatchEvent.Watch event) {
        event.getChunk().m_62954_().forEach((pos, be) -> be.getCapability(CAPABILITY).ifPresent(data -> {
            if (data instanceof VariantDataStorageAttachment) {
                VariantDataStorageAttachment attachment = (VariantDataStorageAttachment)data;
                attachment.syncWith(event.getPlayer());
            }
        }));
        event.getChunk().getCapability(VariantChunkDataStorageAttachment.CAP).ifPresent(data -> data.syncWith(event.getPlayer()));
    }
}

