/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.config.client.screen.builtin.subscreens.list.settings;

import com.mojang.datafixers.util.Either;
import io.github.lightman314.lightmanscurrency.api.config.client.screen.builtin.subscreens.list.settings.EasyListSettings;
import io.github.lightman314.lightmanscurrency.api.config.client.screen.widgets.builtin.list.ListEditBoxOption;
import io.github.lightman314.lightmanscurrency.api.config.options.basic.FloatListOption;
import io.github.lightman314.lightmanscurrency.client.util.text_inputs.FloatParser;
import io.github.lightman314.lightmanscurrency.client.util.text_inputs.TextInputUtil;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.gui.components.AbstractWidget;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class FloatListSettings
extends EasyListSettings<Float, FloatListOption> {
    public FloatListSettings(FloatListOption option, Consumer<Object> changeHandler) {
        super(option, changeHandler);
    }

    @Override
    protected Float getBackupValue() {
        return Float.valueOf(0.0f);
    }

    @Override
    protected Float getNewEntryValue() {
        return Float.valueOf(MathUtil.clamp(0.0f, ((FloatListOption)this.option).lowerLimit, ((FloatListOption)this.option).upperLimit));
    }

    @Override
    protected Either<Float, Void> tryCastValue(Object newValue) {
        if (newValue instanceof Float) {
            Float f = (Float)newValue;
            return Either.left((Object)f);
        }
        return Either.right(null);
    }

    @Override
    public AbstractWidget buildEntry(int index) {
        return ListEditBoxOption.builder(this.option, index, this).inputBoxSetup(handler -> TextInputUtil.floatBuilder().apply(FloatParser.builder().min(((FloatListOption)this.option).lowerLimit).max(((FloatListOption)this.option).upperLimit).consumer()).startingValue((Float)this.getValue(index)).handler(handler::accept)).optionChangeHandler(text -> {
            float newValue = ((Float)this.getValue(index)).floatValue();
            if (newValue == 0.0f && text.m_94155_().isEmpty()) {
                return;
            }
            if (newValue == 0.0f) {
                text.m_94144_("0");
            } else {
                text.m_94144_(String.valueOf(newValue));
            }
        }).build();
    }
}

