/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.config.client.screen.widgets.builtin;

import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.api.config.options.ConfigOption;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.client.gui.easy.interfaces.ITooltipWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyAddonHelper;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyWidgetWithChildren;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import io.github.lightman314.lightmanscurrency.common.util.TooltipHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public abstract class OptionWidget
extends EasyWidgetWithChildren
implements ITooltipWidget {
    public static final int WIDTH = 300;
    public static final int HEIGHT = 20;
    public static final int HALF_WIDTH = 150;
    protected final ConfigOption<?> option;
    private final Consumer<Object> changeConsumer;
    private final List<Pair<AbstractWidget, ScreenPosition>> children = new ArrayList<Pair<AbstractWidget, ScreenPosition>>();

    protected OptionWidget(OptionBuilder<?> builder) {
        super(builder);
        this.option = builder.option;
        this.changeConsumer = builder.changeConsumer;
    }

    protected final <T> T addChildAtRelativePosition(T child, ScreenPosition position) {
        if (child instanceof AbstractWidget) {
            AbstractWidget aw = (AbstractWidget)child;
            this.children.add((Pair<AbstractWidget, ScreenPosition>)Pair.of((Object)aw, (Object)position));
        }
        return this.addChild(child);
    }

    @Override
    protected void renderTick() {
        for (Pair<AbstractWidget, ScreenPosition> pair : this.children) {
            AbstractWidget widget = (AbstractWidget)pair.getFirst();
            widget.f_93624_ = this.isVisible();
            if (!this.isVisible()) continue;
            ScreenPosition newPos = ((ScreenPosition)pair.getSecond()).offset(this.getPosition());
            widget.m_264152_(newPos.x, newPos.y);
        }
    }

    @Override
    protected void renderWidget(EasyGuiGraphics gui) {
        Component name = this.option.getDisplayName();
        int width = gui.font.m_92852_((FormattedText)name);
        gui.drawShadowed(name, 150 - width - 5, 5, 0xFFFFFF);
    }

    @Override
    public List<Component> getTooltipText() {
        return TooltipHelper.splitTooltips(this.option.getCommentTooltips(), new ChatFormatting[0]);
    }

    @Override
    public List<Component> getTooltipText(int mouseX, int mouseY) {
        ScreenArea area = this.getArea();
        ScreenArea leftArea = area.ofSize(area.width / 2, area.height);
        if (leftArea.isMouseInArea(mouseX, mouseY)) {
            return this.getTooltipText();
        }
        return null;
    }

    protected final void changeValue(Object newValue) {
        this.changeConsumer.accept(newValue);
    }

    protected static abstract class OptionBuilder<T extends OptionBuilder<T>>
    extends EasyWidget.EasyBuilder<T> {
        private final ConfigOption<?> option;
        private final Consumer<Object> changeConsumer;

        protected OptionBuilder(ConfigOption<?> option, Consumer<Object> changeConsumer, Supplier<Boolean> active) {
            super(300, 20);
            this.option = option;
            this.changeConsumer = changeConsumer;
            this.addon(EasyAddonHelper.activeCheck(active));
        }
    }
}

