/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.misc.blockentity;

import io.github.lightman314.lightmanscurrency.api.variants.VariantProvider;
import io.github.lightman314.lightmanscurrency.api.variants.block.IVariantBlock;
import io.github.lightman314.lightmanscurrency.api.variants.block.block_entity.IVariantDataStorage;
import io.github.lightman314.lightmanscurrency.common.util.IClientTracker;
import io.github.lightman314.lightmanscurrency.util.BlockEntityUtil;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class EasyBlockEntity
extends BlockEntity
implements IClientTracker,
IVariantDataStorage {
    @Nullable
    private ResourceLocation currentVariant = null;
    private boolean variantLocked = false;

    @Override
    @Nullable
    public ResourceLocation getCurrentVariant() {
        return this.currentVariant;
    }

    @Override
    public boolean isVariantLocked() {
        return this.variantLocked;
    }

    @Override
    public void setVariant(@Nullable ResourceLocation variant, boolean variantLocked) {
        this.currentVariant = variant;
        this.variantLocked = variantLocked;
        this.m_6596_();
        if (this.isServer()) {
            BlockEntityUtil.sendUpdatePacket((BlockEntity)this, this.saveVariantPacket());
        }
    }

    public EasyBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public boolean isClient() {
        return this.f_58857_ == null || this.f_58857_.f_46443_;
    }

    protected final CompoundTag saveVariantPacket() {
        CompoundTag tag = new CompoundTag();
        if (this.currentVariant != null) {
            tag.m_128359_("Variant", this.currentVariant.toString());
        } else {
            tag.m_128379_("NoVariant", true);
        }
        tag.m_128379_("VariantLocked", this.variantLocked);
        return tag;
    }

    protected void m_183515_(CompoundTag tag) {
        if (this.currentVariant != null) {
            tag.m_128359_("Variant", this.currentVariant.toString());
        }
        if (this.variantLocked) {
            tag.m_128379_("VariantLocked", this.variantLocked);
        }
        super.m_183515_(tag);
    }

    public void m_142466_(CompoundTag tag) {
        if (tag.m_128441_("Variant")) {
            this.currentVariant = VersionUtil.parseResource(tag.m_128461_("Variant"));
        } else if (tag.m_128441_("NoVariant")) {
            this.currentVariant = null;
        }
        if (tag.m_128441_("VariantLocked")) {
            this.variantLocked = tag.m_128471_("VariantLocked");
        }
        super.m_142466_(tag);
    }

    public void onLoad() {
        BlockState state;
        if (this.currentVariant != null && VariantProvider.getVariantBlock((state = this.m_58900_()).m_60734_()) != null && !((Boolean)state.m_61143_((Property)IVariantBlock.VARIANT)).booleanValue()) {
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)state.m_61124_((Property)IVariantBlock.VARIANT, (Comparable)Boolean.valueOf(true)));
        }
        if (this.isClient()) {
            BlockEntityUtil.requestUpdatePacket(this);
        }
        super.onLoad();
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }
}

