/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.misc.client.sprites.builtin;

import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.misc.client.sprites.FlexibleHeightSprite;
import io.github.lightman314.lightmanscurrency.api.misc.client.sprites.SpriteSource;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class VerticalSliceSprite
implements FlexibleHeightSprite {
    public final SpriteSource image;
    private final int edge;

    public VerticalSliceSprite(SpriteSource image, int edge) {
        this.image = image;
        this.edge = edge;
    }

    @Override
    public void render(EasyGuiGraphics gui, int x, int y, int height) {
        int heightToDraw;
        int vCenter = this.image.height() - this.edge - this.edge;
        if (vCenter < 0) {
            return;
        }
        gui.blit(this.image.texture(), x, y, this.image.u(), this.image.v(), this.image.width(), this.edge, this.image.textureWidth(), this.image.textureHeight());
        for (int tempY = this.edge; tempY < height - this.edge; tempY += heightToDraw) {
            heightToDraw = Math.min(vCenter, height - this.edge - tempY);
            gui.blit(this.image.texture(), x, y + tempY, this.image.u(), this.image.v() + this.edge, this.image.width(), heightToDraw, this.image.textureWidth(), this.image.textureHeight());
        }
        gui.blit(this.image.texture(), x, y + height - this.edge, this.image.u(), this.image.v() + this.image.height() - this.edge, this.image.width(), this.edge, this.image.textureWidth(), this.image.textureHeight());
    }

    @Override
    public int getWidth() {
        return this.image.width();
    }
}

