/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.misc.icons;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.misc.icons.IconData;
import io.github.lightman314.lightmanscurrency.util.FileUtil;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ItemIcon
extends IconData {
    public static final IconData.Type TYPE = new IconData.Type(VersionUtil.lcResource("item"), ItemIcon::loadIcon, ItemIcon::parseIcon);
    private final ItemStack iconStack;
    private final String countTextOverride;

    private ItemIcon(ItemStack iconStack, @Nullable String countTextOverride) {
        super(TYPE);
        this.iconStack = iconStack;
        this.countTextOverride = countTextOverride;
    }

    public static IconData ofItem(Supplier<? extends ItemLike> item) {
        return ItemIcon.ofItem(item.get());
    }

    public static IconData ofItem(Supplier<? extends ItemLike> item, @Nullable String countTextOverride) {
        return ItemIcon.ofItem(item.get(), countTextOverride);
    }

    public static IconData ofItem(ItemLike item) {
        return ItemIcon.ofItem(new ItemStack(item));
    }

    public static IconData ofItem(ItemLike item, @Nullable String countTextOverride) {
        return ItemIcon.ofItem(new ItemStack(item), countTextOverride);
    }

    public static IconData ofItem(ItemStack item) {
        return new ItemIcon(item, null);
    }

    public static IconData ofItem(ItemStack item, @Nullable String countTextOverride) {
        return new ItemIcon(item, countTextOverride);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(EasyGuiGraphics gui, int x, int y) {
        gui.renderItem(this.iconStack, x, y, this.countTextOverride);
    }

    @Override
    protected void saveAdditional(CompoundTag tag) {
        tag.m_128365_("Item", (Tag)InventoryUtil.saveItemNoLimits(this.iconStack));
        if (this.countTextOverride != null) {
            tag.m_128359_("Text", this.countTextOverride);
        }
    }

    @Override
    protected void writeAdditional(JsonObject json) {
        json.add("Item", (JsonElement)FileUtil.convertItemStack(this.iconStack));
        if (this.countTextOverride != null) {
            json.addProperty("Text", this.countTextOverride);
        }
    }

    private static IconData loadIcon(CompoundTag tag) {
        ItemStack stack = InventoryUtil.loadItemNoLimits(tag.m_128469_("Item"));
        String countText = null;
        if (tag.m_128441_("Text")) {
            countText = tag.m_128461_("Text");
        }
        return new ItemIcon(stack, countText);
    }

    private static IconData parseIcon(JsonObject json) {
        ItemStack stack = FileUtil.parseItemStack(GsonHelper.m_13930_((JsonObject)json, (String)"Item"));
        String countText = GsonHelper.m_13851_((JsonObject)json, (String)"Text", null);
        return new ItemIcon(stack, countText);
    }
}

