/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.misc.icons;

import com.google.gson.JsonObject;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.misc.icons.IconData;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class NumberIcon
extends IconData {
    public static final IconData.Type TYPE = new IconData.Type(VersionUtil.lcResource("number_icon"), NumberIcon::loadIcon, NumberIcon::parseIcon);
    private final int number;

    private NumberIcon(int number) {
        super(TYPE);
        this.number = number;
    }

    public static IconData ofNumber(int number) {
        return new NumberIcon(number);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(EasyGuiGraphics gui, int x, int y) {
        String text = String.valueOf(this.number);
        int width = gui.font.m_92895_(text);
        gui.drawShadowed(text, x + 17 - width, y + 9, 0xFFFFFF);
    }

    @Override
    protected void saveAdditional(CompoundTag tag) {
        tag.m_128405_("Number", this.number);
    }

    @Override
    protected void writeAdditional(JsonObject json) {
        json.addProperty("Number", (Number)this.number);
    }

    private static IconData loadIcon(CompoundTag tag) {
        return new NumberIcon(tag.m_128451_("Number"));
    }

    private static IconData parseIcon(JsonObject json) {
        return new NumberIcon(GsonHelper.m_13927_((JsonObject)json, (String)"Number"));
    }
}

