/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.misc.icons;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.misc.icons.IconData;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class TextIcon
extends IconData {
    public static final IconData.Type TYPE = new IconData.Type(VersionUtil.lcResource("text"), TextIcon::loadIcon, TextIcon::parseIcon);
    private final Component iconText;
    private final int textColor;

    private TextIcon(Component iconText, int textColor) {
        super(TYPE);
        this.iconText = iconText;
        this.textColor = textColor;
    }

    public static IconData ofText(Component text) {
        return TextIcon.ofText(text, 0xFFFFFF);
    }

    public static IconData ofText(Component text, int textColor) {
        return new TextIcon(text, textColor);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(EasyGuiGraphics gui, int x, int y) {
        int xPos = x + 8 - gui.font.m_92852_((FormattedText)this.iconText) / 2;
        Objects.requireNonNull(gui.font);
        int yPos = y + (16 - 9) / 2;
        gui.drawShadowed(this.iconText, xPos, yPos, this.textColor);
    }

    @Override
    protected void saveAdditional(CompoundTag tag) {
        tag.m_128359_("Text", Component.Serializer.m_130703_((Component)this.iconText));
        tag.m_128405_("Color", this.textColor);
    }

    @Override
    protected void writeAdditional(JsonObject json) {
        json.add("Text", Component.Serializer.m_130716_((Component)this.iconText));
        json.addProperty("Color", (Number)this.textColor);
    }

    private static IconData loadIcon(CompoundTag tag) {
        MutableComponent text = Component.Serializer.m_130701_((String)tag.m_128461_("Text"));
        int color = tag.m_128451_("Color");
        return new TextIcon((Component)text, color);
    }

    private static IconData parseIcon(JsonObject json) {
        MutableComponent text = Component.Serializer.m_130691_((JsonElement)json.get("Text"));
        int color = GsonHelper.m_13824_((JsonObject)json, (String)"Color", (int)0x404040);
        return new TextIcon((Component)text, color);
    }
}

