/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.taxes;

import io.github.lightman314.lightmanscurrency.api.taxes.ITaxable;
import java.util.Set;

public interface ITaxableContext {
    public ITaxable taxable();

    public boolean networkAccess();

    public static ITaxableContext defaultContext(ITaxable taxable) {
        return ITaxableContext.simpleContext(taxable, false);
    }

    public static ITaxableContext simpleContext(ITaxable taxable, boolean networkAccess) {
        return new SimpleContext(taxable, networkAccess);
    }

    public static Set<ITaxableContext> defaultSet(ITaxable taxable) {
        return Set.of(ITaxableContext.defaultContext(taxable));
    }

    public static Set<ITaxableContext> fullSet(ITaxable taxable) {
        return Set.of(ITaxableContext.simpleContext(taxable, true), ITaxableContext.simpleContext(taxable, false));
    }

    public static final class SimpleContext
    implements ITaxableContext {
        private final ITaxable taxable;
        private final boolean networkAccess;

        private SimpleContext(ITaxable taxable, boolean networkAccess) {
            this.taxable = taxable;
            this.networkAccess = networkAccess;
        }

        @Override
        public ITaxable taxable() {
            return this.taxable;
        }

        @Override
        public boolean networkAccess() {
            return this.networkAccess;
        }
    }
}

