/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.traders;

import com.google.gson.JsonObject;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.util.NonNullSupplier;

public final class TraderType<T extends TraderData> {
    public final ResourceLocation type;
    private final NonNullSupplier<T> generator;

    public TraderType(@Nonnull ResourceLocation type, @Nonnull NonNullSupplier<T> generator) {
        this.type = type;
        this.generator = generator;
    }

    public T create() {
        return (T)((TraderData)this.generator.get());
    }

    public T load(boolean isClient, @Nonnull CompoundTag tag) {
        TraderData trader = (TraderData)this.generator.get();
        trader.load(tag);
        if (isClient) {
            trader.flagAsClient();
        }
        return (T)trader;
    }

    public T loadFromJson(@Nonnull JsonObject json) {
        TraderData trader = (TraderData)this.generator.get();
        trader.loadFromJson(json);
        return (T)trader;
    }

    public String toString() {
        return this.type.toString();
    }
}

