/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.upgrades.slot;

import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.api.upgrades.IUpgradeable;
import io.github.lightman314.lightmanscurrency.common.items.UpgradeItem;
import io.github.lightman314.lightmanscurrency.common.menus.slots.easy.EasySlot;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class UpgradeInputSlot
extends EasySlot {
    public static final ResourceLocation EMPTY_UPGRADE_SLOT = VersionUtil.lcResource("item/empty_upgrade_slot");
    private final Container inventory;
    private final IUpgradeable machine;
    private final Runnable onModified;

    public UpgradeInputSlot(Container inventory, int index, int x, int y, IUpgradeable machine) {
        this(inventory, index, x, y, machine, () -> {});
    }

    public UpgradeInputSlot(Container inventory, int index, int x, int y, IUpgradeable machine, Runnable onModified) {
        super(inventory, index, x, y);
        this.inventory = inventory;
        this.machine = machine;
        this.onModified = onModified;
    }

    @Override
    public boolean m_5857_(@Nonnull ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof UpgradeItem) {
            UpgradeItem item2 = (UpgradeItem)item;
            return this.machine.allowUpgrade(item2) && UpgradeItem.noUniqueConflicts(item2, this.inventory);
        }
        return false;
    }

    public int m_6641_() {
        return 1;
    }

    @Override
    public void m_6654_() {
        super.m_6654_();
        if (this.onModified != null) {
            this.onModified.run();
        }
    }

    public Pair<ResourceLocation, ResourceLocation> m_7543_() {
        return Pair.of((Object)InventoryMenu.f_39692_, (Object)EMPTY_UPGRADE_SLOT);
    }
}

