/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.variants.item;

import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.ModelVariantDataManager;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

@MethodsReturnNonnullByDefault
public interface IVariantItem {
    default public ResourceLocation getItemID() {
        IVariantItem iVariantItem = this;
        if (iVariantItem instanceof ItemLike) {
            ItemLike item = (ItemLike)iVariantItem;
            return ForgeRegistries.ITEMS.getKey((Object)item.m_5456_());
        }
        throw new IllegalStateException("IVariantItem must be applied to an Item class!");
    }

    default public List<ResourceLocation> getValidVariants() {
        return ModelVariantDataManager.getPotentialVariants(this.getItemID());
    }

    default public int requiredModels() {
        return 0;
    }

    @Nullable
    default public ResourceLocation getDefaultModel(int index) {
        if (this.requiredModels() > 0) {
            throw new IllegalStateException("Variant Item requires custom model, but does not provide the default for that model!");
        }
        return null;
    }

    public static void setItemVariant(ItemStack item, @Nullable ResourceLocation variantID) {
        CompoundTag tag = item.m_41784_();
        if (variantID == null) {
            tag.m_128473_("ModelVariant");
            if (tag.m_128456_()) {
                tag = null;
            }
        } else {
            tag.m_128359_("ModelVariant", variantID.toString());
        }
        item.m_41751_(tag);
    }

    @Nullable
    public static ResourceLocation getItemVariant(ItemStack item) {
        CompoundTag tag = item.m_41783_();
        if (tag == null || !tag.m_128441_("ModelVariant")) {
            return null;
        }
        return VersionUtil.parseResource(tag.m_128461_("ModelVariant"));
    }

    public static boolean isLocked(ItemStack item) {
        CompoundTag tag = item.m_41783_();
        return tag != null && tag.m_128471_("VariantLock");
    }

    public static void setLocked(ItemStack item, boolean locked) {
        CompoundTag tag = item.m_41784_();
        if (locked) {
            tag.m_128379_("VariantLock", true);
        } else {
            tag.m_128473_("VariantLock");
            if (tag.m_128456_()) {
                tag = null;
            }
        }
        item.m_41751_(tag);
    }
}

