/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.config;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.config.options.ListLikeOption;
import io.github.lightman314.lightmanscurrency.api.config.options.ListOption;
import io.github.lightman314.lightmanscurrency.api.config.options.basic.StringOption;
import io.github.lightman314.lightmanscurrency.api.config.options.parsing.ConfigParser;
import io.github.lightman314.lightmanscurrency.api.config.options.parsing.ConfigParsingException;
import io.github.lightman314.lightmanscurrency.client.config.CustomItemScaleData;
import io.github.lightman314.lightmanscurrency.client.config.ItemTest;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public class CustomItemScaleConfigOption
extends ListLikeOption<CustomItemScaleData> {
    public static final ConfigParser<CustomItemScaleData> PARSER = ListOption.makeParser(StringOption.PARSER).map(CustomItemScaleConfigOption::read, CustomItemScaleConfigOption::write);

    protected CustomItemScaleConfigOption(@Nonnull Supplier<CustomItemScaleData> defaultValue) {
        super(defaultValue);
    }

    public static CustomItemScaleConfigOption create() {
        return CustomItemScaleConfigOption.create(CustomItemScaleData.EMPTY);
    }

    public static CustomItemScaleConfigOption create(CustomItemScaleData defaultValue) {
        return CustomItemScaleConfigOption.create(() -> defaultValue);
    }

    public static CustomItemScaleConfigOption create(Supplier<CustomItemScaleData> defaultValue) {
        return new CustomItemScaleConfigOption(defaultValue);
    }

    @Override
    @Nonnull
    protected List<String> bonusComments() {
        return Lists.newArrayList((Object[])new String[]{"Should be formatted as \"namespace:item_id;SCALE\" where SCALE is decimal number between 0.0 and 1.0 (exclusive)", "Scale of 1.0 will be drawn at full size, Scale of 0.0 will not draw at all", "Can define an item tag instead of an item by formatting as \"#namespace:item_tag;SCALE\" instead"});
    }

    @Override
    @Nonnull
    public Pair<Boolean, ConfigParsingException> editList(String value, int index, boolean isEdit) {
        if (index < 0 && isEdit) {
            try {
                Pair<ItemTest, Float> newValue = CustomItemScaleData.parse(CustomItemScaleConfigOption.cleanWhitespace(value));
                List<Pair<ItemTest, Float>> currentValue = ((CustomItemScaleData)this.getCurrentValue()).getRawData();
                currentValue.add(newValue);
                this.set(new CustomItemScaleData(currentValue));
                return Pair.of((Object)true, null);
            }
            catch (ConfigParsingException e) {
                return Pair.of((Object)false, (Object)e);
            }
        }
        if (index >= 0) {
            List<Pair<ItemTest, Float>> currentValue = ((CustomItemScaleData)this.getCurrentValue()).getRawData();
            if (index >= currentValue.size()) {
                return Pair.of((Object)false, (Object)new ConfigParsingException("Invalid index. Maximum is " + (currentValue.size() - 1) + "!"));
            }
            if (isEdit) {
                try {
                    Pair<ItemTest, Float> newValue = CustomItemScaleData.parse(CustomItemScaleConfigOption.cleanWhitespace(value));
                    currentValue.set(index, newValue);
                    this.set(new CustomItemScaleData(currentValue));
                    return Pair.of((Object)true, null);
                }
                catch (ConfigParsingException e) {
                    return Pair.of((Object)false, (Object)e);
                }
            }
            currentValue.remove(index);
            this.set(new CustomItemScaleData(currentValue));
            return Pair.of((Object)true, null);
        }
        return null;
    }

    @Override
    public int getSize() {
        return ((CustomItemScaleData)this.getCurrentValue()).getRawData().size();
    }

    @Override
    @Nonnull
    protected ConfigParser<CustomItemScaleData> getParser() {
        return PARSER;
    }

    private static CustomItemScaleData read(List<String> list) {
        ArrayList<Pair<ItemTest, Float>> results = new ArrayList<Pair<ItemTest, Float>>();
        for (int s = 0; s < list.size(); ++s) {
            try {
                results.add(CustomItemScaleData.parse(list.get(s)));
                continue;
            }
            catch (ConfigParsingException e) {
                LightmansCurrency.LogWarning("Failed to parse List Config entry #" + (s + 1), e);
            }
        }
        return new CustomItemScaleData(results);
    }

    private static List<String> write(CustomItemScaleData value) {
        ArrayList<String> list = new ArrayList<String>();
        for (Pair<ItemTest, Float> v : value.getRawData()) {
            list.add(CustomItemScaleData.write(v));
        }
        return list;
    }
}

