/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.config.master_coin_list;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.client.gui.screen.config.master_coin_list.MCLChainEditScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.config.master_coin_list.MCLSubscreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.config.master_coin_list.data.MutableChainData;
import io.github.lightman314.lightmanscurrency.client.gui.screen.config.master_coin_list.data.MutableMasterCoinList;
import io.github.lightman314.lightmanscurrency.client.gui.widget.ScrollListener;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyAddonHelper;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyTextButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.scroll.IScrollable;
import io.github.lightman314.lightmanscurrency.client.gui.widget.scroll.ScrollBarWidget;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.text_inputs.TextBoxWrapper;
import io.github.lightman314.lightmanscurrency.client.util.text_inputs.TextInputUtil;
import io.github.lightman314.lightmanscurrency.common.text.TextEntry;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class MCLChainSelectScreen
extends MCLSubscreen
implements IScrollable {
    private int scroll = 0;
    private int visibleChains = 1;
    TextBoxWrapper<String> newChainInput;

    public MCLChainSelectScreen(Screen parentScreen) {
        super(new MutableMasterCoinList(), parentScreen);
    }

    @Override
    protected void addTitleSections(List<Component> list) {
    }

    @Override
    public int currentScroll() {
        return this.scroll;
    }

    @Override
    public void setScroll(int newScroll) {
        this.scroll = newScroll;
    }

    @Override
    public int getMaxScroll() {
        return IScrollable.calculateMaxScroll(this.visibleChains, this.getData().size());
    }

    @Override
    protected void initialize(ScreenArea screenArea) {
        int centerX = screenArea.centerX();
        this.visibleChains = Math.max(1, (screenArea.height - this.footerSize() - this.headerSize() - 50) / 25);
        this.validateScroll();
        int yPos = this.headerSize() + 5;
        int i = 0;
        while (i < this.visibleChains) {
            int index = i++;
            this.addChild(((EasyTextButton.Builder)((EasyTextButton.Builder)((EasyTextButton.Builder)((EasyTextButton.Builder)((EasyTextButton.Builder)EasyTextButton.builder().position(centerX - 100, yPos)).width(200)).text(() -> this.getButtonText(index)).pressAction(() -> this.selectChain(index))).addon(EasyAddonHelper.tooltips(() -> this.getButtonTooltip(index)))).addon(EasyAddonHelper.visibleCheck(() -> this.hasDataEntry(index)))).build());
            yPos += 25;
        }
        this.newChainInput = this.addChild(((TextBoxWrapper.Builder)TextInputUtil.stringBuilder().position(centerX - 100, screenArea.height - this.footerSize() - 45).width(200).maxLength(16).filter(TextInputUtil::noEmptySpaces).wrap().addon(EasyAddonHelper.visibleCheck(this::canEdit))).build());
        this.addChild(((EasyTextButton.Builder)((EasyTextButton.Builder)((EasyTextButton.Builder)((EasyTextButton.Builder)((EasyTextButton.Builder)EasyTextButton.builder().position(centerX - 100, screenArea.height - this.footerSize() - 25)).width(200)).text(LCText.CONFIG_MCL_CHAIN_SELECT_NEW_CHAIN).pressAction(this::createNewChain)).addon(EasyAddonHelper.activeCheck(this::validChainInput))).addon(EasyAddonHelper.visibleCheck(this::canEdit))).build());
        this.addChild(((ScrollListener.Builder)ScrollListener.builder().area(screenArea)).listener(this).build());
        this.addChild(((ScrollBarWidget.Builder)ScrollBarWidget.builder().position(centerX + 110, this.headerSize() + 5)).height(this.visibleChains * 25 - 5).scrollable(this).build());
        this.addChild(((EasyTextButton.Builder)((EasyTextButton.Builder)((EasyTextButton.Builder)EasyTextButton.builder().position(centerX - 100, screenArea.height - 25)).width(98)).text(this::getBackButtonText).pressAction(this::m_7379_)).build());
        this.addChild(((EasyTextButton.Builder)((EasyTextButton.Builder)((EasyTextButton.Builder)((EasyTextButton.Builder)EasyTextButton.builder().position(centerX + 2, screenArea.height - 25)).width(98)).text((Component)LCText.CONFIG_MCL_SAVE_CHANGES.get(new Object[0])).addon(EasyAddonHelper.activeCheck(this::canEdit))).pressAction(this::uploadChanges)).build());
    }

    private Component getBackButtonText() {
        return this.canEdit() ? LCText.CONFIG_MCL_EXIT_WITHOUT_SAVING.get(new Object[0]) : LCText.CONFIG_BACK.get(new Object[0]);
    }

    private boolean hasDataEntry(int localIndex) {
        return this.getDataEntry(localIndex) != null;
    }

    private List<String> sortedKeyList() {
        ArrayList<String> keys = new ArrayList<String>(this.getData().keySet());
        keys.sort(String::compareToIgnoreCase);
        return keys;
    }

    @Nullable
    private MutableChainData getDataEntry(int localIndex) {
        int trueIndex = localIndex + this.scroll;
        List<String> keyList = this.sortedKeyList();
        if (trueIndex < 0 || trueIndex >= keyList.size()) {
            return null;
        }
        return this.getData().get(keyList.get(trueIndex));
    }

    private Component getButtonText(int localIndex) {
        MutableChainData chain = this.getDataEntry(localIndex);
        if (chain != null) {
            return chain.displayName.m_6881_();
        }
        return EasyText.empty();
    }

    private List<Component> getButtonTooltip(int localIndex) {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        MutableChainData chain = this.getDataEntry(localIndex);
        if (chain != null) {
            tooltip.addAll(LCText.CONFIG_MCL_CHAIN_SELECT_CHAIN_INFO.get(chain.getChain(), chain.coreChain.entryCount(), chain.sideChains.size(), LCText.GUI_SETTINGS_VALUE_TRUE_FALSE.get(chain.isEvent)));
        }
        return tooltip;
    }

    private void selectChain(int localIndex) {
        MutableChainData chain = this.getDataEntry(localIndex);
        if (chain != null) {
            this.selectChain(chain);
        }
    }

    private void selectChain(MutableChainData chain) {
        this.f_96541_.m_91152_((Screen)new MCLChainEditScreen(this, chain));
    }

    private boolean validChainInput() {
        if (this.newChainInput == null) {
            return false;
        }
        return this.validChainID(this.newChainInput.getValue());
    }

    private boolean validChainID(String newChainID) {
        return !newChainID.isBlank() && !this.getData().containsKey(newChainID);
    }

    private void createNewChain() {
        String newChainID;
        if (this.newChainInput != null && this.validChainID(newChainID = this.newChainInput.getValue())) {
            MutableChainData newChain = this.createChain(newChainID);
            newChain.displayName = TextEntry.chain(newChainID).get(new Object[0]);
            this.newChainInput.setValue("");
            this.selectChain(newChain);
        }
    }

    private void uploadChanges() {
    }
}

