/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.coin_chest;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.QuarantineAPI;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.misc.icons.IconUtil;
import io.github.lightman314.lightmanscurrency.api.money.bank.IBankAccount;
import io.github.lightman314.lightmanscurrency.api.money.input.MoneyValueWidget;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.coin_chest.CoinChestTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyAddonHelper;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyTextButton;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.TextRenderUtil;
import io.github.lightman314.lightmanscurrency.common.upgrades.types.coin_chest.CoinChestBankUpgrade;
import io.github.lightman314.lightmanscurrency.common.upgrades.types.coin_chest.CoinChestUpgrade;
import io.github.lightman314.lightmanscurrency.common.upgrades.types.coin_chest.CoinChestUpgradeData;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class BankUpgradeSettingsTab
extends CoinChestTab.Upgrade {
    private MoneyValueWidget oldWidget = null;

    public BankUpgradeSettingsTab(@Nonnull CoinChestUpgradeData data, @Nonnull Object screen) {
        super(data, screen);
    }

    @Override
    public boolean coinSlotsVisible() {
        return false;
    }

    @Override
    protected void initialize(ScreenArea screenArea, boolean firstOpen) {
        CoinChestUpgrade coinChestUpgrade;
        this.addChild(((EasyTextButton.Builder)((EasyTextButton.Builder)((EasyTextButton.Builder)EasyTextButton.builder().position(screenArea.pos.offset(20, 20))).width(screenArea.width - 40)).text(this::getModeButtonText).pressAction(this::toggleDepositMode)).build());
        MoneyValue moneyLimit = MoneyValue.empty();
        CoinChestUpgradeData data = this.getUpgradeData();
        if (data != null && (coinChestUpgrade = data.upgrade) instanceof CoinChestBankUpgrade) {
            CoinChestBankUpgrade upgrade = (CoinChestBankUpgrade)coinChestUpgrade;
            moneyLimit = upgrade.getMoneyLimit(data);
        }
        this.oldWidget = this.addChild(((MoneyValueWidget.Builder)MoneyValueWidget.builder().position(screenArea.pos.offset(screenArea.width / 2 - 88, 50))).oldIfNotFirst(firstOpen, this.oldWidget).startingValue(moneyLimit).valueHandler(this::onMoneyLimitChange).blockFreeInputs().build());
        this.addChild(((IconButton.Builder)((IconButton.Builder)((IconButton.Builder)IconButton.builder().position(screenArea.pos.offset(screenArea.width, 0))).pressAction(this::collectOverflowItems)).icon(IconUtil.ICON_STORAGE).addon(EasyAddonHelper.visibleCheck(this::hasOverflowItems))).build());
    }

    @Override
    public void renderBG(@Nonnull EasyGuiGraphics gui) {
        CoinChestUpgrade coinChestUpgrade;
        CoinChestUpgradeData data = this.getUpgradeData();
        if (data != null && (coinChestUpgrade = data.upgrade) instanceof CoinChestBankUpgrade) {
            CoinChestBankUpgrade upgrade = (CoinChestBankUpgrade)coinChestUpgrade;
            boolean depositMode = upgrade.isDepositMode(data);
            MoneyValue moneyLimit = upgrade.getMoneyLimit(data);
            IBankAccount account = upgrade.getSelectedBankAccount(this.menu.be, data);
            MutableComponent text = QuarantineAPI.IsDimensionQuarantined(this.menu.be) ? LCText.MESSAGE_DIMENSION_QUARANTINED_BANK.get(new Object[0]) : (account == null ? LCText.GUI_BANK_UPGRADE_DETAILS_NO_ACCOUNT.get(new Object[0]) : (depositMode ? (moneyLimit.isEmpty() ? LCText.GUI_BANK_UPGRADE_DETAILS_DEPOSIT_UNLIMITED.get(new Object[0]) : LCText.GUI_BANK_UPGRADE_DETAILS_DEPOSIT_LIMITED.get(moneyLimit.getText())) : (moneyLimit.isEmpty() ? LCText.GUI_BANK_UPGRADE_DETAILS_WITHDRAW_INVALID.get(new Object[0]) : LCText.GUI_BANK_UPGRADE_DETAILS_WITHDRAW.get(moneyLimit.getText()))));
            TextRenderUtil.drawCenteredMultilineText(gui, (Component)text, 20, this.screen.getXSize() - 40, 122, 0x404040);
        }
    }

    private Component getModeButtonText() {
        CoinChestBankUpgrade upgrade;
        CoinChestUpgrade coinChestUpgrade = this.getUpgradeData().upgrade;
        boolean depositMode = coinChestUpgrade instanceof CoinChestBankUpgrade && (upgrade = (CoinChestBankUpgrade)coinChestUpgrade).isDepositMode(this.getUpgradeData());
        return depositMode ? LCText.BUTTON_BANK_UPGRADE_MODE_DEPOSIT.get(new Object[0]) : LCText.BUTTON_BANK_UPGRADE_MODE_WITHDRAW.get(new Object[0]);
    }

    private void toggleDepositMode() {
        CoinChestBankUpgrade upgrade;
        CoinChestUpgrade coinChestUpgrade;
        CoinChestUpgradeData data = this.getUpgradeData();
        boolean currentState = data != null && (coinChestUpgrade = data.upgrade) instanceof CoinChestBankUpgrade && (upgrade = (CoinChestBankUpgrade)coinChestUpgrade).isDepositMode(data);
        this.menu.SendMessageToServer(this.builder().setBoolean("SetDepositMode", !currentState));
    }

    private void onMoneyLimitChange(@Nonnull MoneyValue newLimit) {
        this.menu.SendMessageToServer(this.builder().setMoneyValue("SetMoneyLimit", newLimit));
    }

    private boolean hasOverflowItems() {
        CoinChestBankUpgrade upgrade;
        CoinChestUpgrade coinChestUpgrade;
        CoinChestUpgradeData data = this.getUpgradeData();
        return data != null && (coinChestUpgrade = data.upgrade) instanceof CoinChestBankUpgrade && !(upgrade = (CoinChestBankUpgrade)coinChestUpgrade).getOverflowItems(data).isEmpty();
    }

    private void collectOverflowItems(EasyButton button) {
        this.menu.SendMessageToServer(this.builder().setFlag("CollectOverflowItems"));
    }
}

