/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderinterface;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.misc.icons.IconData;
import io.github.lightman314.lightmanscurrency.api.misc.icons.IconUtil;
import io.github.lightman314.lightmanscurrency.api.trader_interface.menu.TraderInterfaceClientTab;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.trade.TradeData;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderInterfaceScreen;
import io.github.lightman314.lightmanscurrency.client.gui.widget.TradeButtonArea;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.common.menus.TraderInterfaceMenu;
import io.github.lightman314.lightmanscurrency.common.menus.traderinterface.base.TradeSelectTab;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.MutableComponent;

public class TradeSelectClientTab
extends TraderInterfaceClientTab<TradeSelectTab> {
    TradeButtonArea tradeDisplay;

    public TradeSelectClientTab(Object screen, TradeSelectTab commonTab) {
        super(screen, commonTab);
    }

    @Override
    @Nonnull
    public IconData getIcon() {
        return IconUtil.ICON_TRADER;
    }

    public MutableComponent getTooltip() {
        return LCText.TOOLTIP_INTERFACE_TRADE_SELECT.get(new Object[0]);
    }

    @Override
    public boolean blockInventoryClosing() {
        return this.tradeDisplay.isSearchBoxRelevant();
    }

    @Override
    public void initialize(ScreenArea screenArea, boolean firstOpen) {
        this.tradeDisplay = this.addChild(((TradeButtonArea.Builder)((TradeButtonArea.Builder)TradeButtonArea.builder().position(screenArea.pos.offset(3, 17))).size(screenArea.width - 6, 100)).traderSource(((TraderInterfaceMenu)this.menu).getBE().targets::getTrader).context(((TraderInterfaceMenu)this.menu).getBE()::getTradeContext).pressAction(this::ToggleTrade).tradeFilter(TradeData::isValid).title(screenArea.pos.offset(4, 6), screenArea.width - 8, false).selectedState(this::isTradeSelected).build());
    }

    @Override
    public void renderBG(@Nonnull EasyGuiGraphics gui) {
    }

    @Override
    public void tick() {
        if (!((TradeSelectTab)this.commonTab).canOpen(((TraderInterfaceMenu)this.menu).player)) {
            ((TraderInterfaceScreen)this.screen).changeTab(0);
        }
    }

    private boolean isTradeSelected(TraderData trader, TradeData trade) {
        return ((TraderInterfaceMenu)this.menu).getBE().targets.getTradeReferences().stream().anyMatch(t -> t.getTrueTrade() == trade);
    }

    private int getTradeIndex(TraderData trader, TradeData trade) {
        return trader.getTradeData().indexOf(trade);
    }

    private void ToggleTrade(TraderData trader, TradeData trade) {
        ((TradeSelectTab)this.commonTab).toggleTradeIndex(this.getTradeIndex(trader, trade));
    }
}

