/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.core;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.misc.client.sprites.SpriteUtil;
import io.github.lightman314.lightmanscurrency.api.misc.icons.IconData;
import io.github.lightman314.lightmanscurrency.api.misc.icons.IconUtil;
import io.github.lightman314.lightmanscurrency.api.settings.SettingsNode;
import io.github.lightman314.lightmanscurrency.api.settings.SettingsSubNode;
import io.github.lightman314.lightmanscurrency.api.settings.data.NodeSelections;
import io.github.lightman314.lightmanscurrency.api.settings.data.SavedSettingData;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.ITraderStorageMenu;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.ITraderStorageScreen;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.TraderStorageClientTab;
import io.github.lightman314.lightmanscurrency.client.gui.easy.interfaces.IEasyScreen;
import io.github.lightman314.lightmanscurrency.client.gui.widget.ScrollListener;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.PlainButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyAddonHelper;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyTextButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.scroll.IScrollable;
import io.github.lightman314.lightmanscurrency.client.gui.widget.scroll.ScrollBarWidget;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import io.github.lightman314.lightmanscurrency.common.menus.traderstorage.core.SettingsClipboardTab;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.util.GsonHelper;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class SettingsClipboardClientTab
extends TraderStorageClientTab<SettingsClipboardTab>
implements IScrollable {
    public static final int NODES_PER_PAGE = 8;
    private NodeSelections selections = new NodeSelections();
    private final List<Pair<NodeKey, PlainButton>> toggleSwitches = new ArrayList<Pair<NodeKey, PlainButton>>();
    private int scroll = 0;

    public SettingsClipboardClientTab(Object screen, SettingsClipboardTab commonTab) {
        super(screen, commonTab);
        ((SettingsClipboardTab)this.commonTab).setCopyResultConsumer(this::setClipboard);
    }

    @Override
    protected void initialize(ScreenArea screenArea, boolean firstOpen) {
        TraderData trader = ((ITraderStorageMenu)this.menu).getTrader();
        this.addChild(((EasyTextButton.Builder)((EasyTextButton.Builder)((EasyTextButton.Builder)EasyTextButton.builder().position(screenArea.pos.offset(10, 120))).width(74)).text(LCText.BUTTON_TRADER_SETTINGS_COPY).pressAction(this::tryCopy)).build());
        this.addChild(((EasyTextButton.Builder)((EasyTextButton.Builder)((EasyTextButton.Builder)((EasyTextButton.Builder)EasyTextButton.builder().position(screenArea.pos.offset(122, 120))).width(74)).text(LCText.BUTTON_TRADER_SETTINGS_PASTE).pressAction(this::tryLoad)).addon(EasyAddonHelper.activeCheck(this::canReadSettings))).build());
        this.addChild(((ScrollBarWidget.Builder)ScrollBarWidget.builder().position(screenArea.pos.offset(10, 8))).height(112).scrollable(this).build());
        this.addChild(((ScrollListener.Builder)ScrollListener.builder().area(screenArea.ofSize(screenArea.width, 142))).listener(this).build());
        if (trader == null) {
            return;
        }
        if (firstOpen) {
            this.scroll = 0;
            this.selections = trader.defaultNodeSelections(((ITraderStorageMenu)this.menu).getPlayer());
        }
        this.toggleSwitches.clear();
        for (SettingsNode node : trader.getAllSettingNodes()) {
            NodeKey key = new NodeKey(node.key, null);
            PlainButton button = this.addChild(((PlainButton.Builder)((PlainButton.Builder)PlainButton.builder().position(screenArea.pos.offset(20, 0))).sprite(SpriteUtil.createCheckbox(() -> this.isNodeSelected(key))).pressAction(() -> this.toggleNode(key))).build());
            this.toggleSwitches.add((Pair<NodeKey, PlainButton>)Pair.of((Object)key, (Object)((Object)button)));
            LightmansCurrency.LogDebug("Adding node switch for " + key);
            for (SettingsSubNode<?> subNode : node.getSubNodes()) {
                NodeKey subKey = new NodeKey(node.key, subNode.getSubKey());
                button = this.addChild(((PlainButton.Builder)((PlainButton.Builder)PlainButton.builder().position(screenArea.pos.offset(30, 0))).sprite(SpriteUtil.createCheckbox(() -> this.isNodeSelected(subKey))).pressAction(() -> this.toggleNode(subKey))).build());
                this.toggleSwitches.add((Pair<NodeKey, PlainButton>)Pair.of((Object)subKey, (Object)((Object)button)));
                LightmansCurrency.LogDebug("Adding subnode switch for " + subKey);
            }
        }
    }

    private boolean canReadSettings() {
        if (((SettingsClipboardTab)this.commonTab).canReadSettingsFromStack()) {
            return true;
        }
        try {
            JsonObject json = GsonHelper.m_13869_((String)this.getClipboard(), (boolean)true);
            SavedSettingData data = SavedSettingData.read((JsonElement)json);
            return true;
        }
        catch (JsonParseException | IllegalStateException ignored) {
            return false;
        }
    }

    @Override
    public void renderBG(EasyGuiGraphics gui) {
        this.validateScroll();
        List<Pair<Boolean, Component>> visibleNodesNames = this.refactorToggleButtons();
        gui.renderSlot((IEasyScreen)this.screen, ((SettingsClipboardTab)this.commonTab).getSlot());
        TraderData trader = ((ITraderStorageMenu)this.menu).getTrader();
        int startIndex = this.scroll;
        int y = 9;
        for (Pair<Boolean, Component> nodeName : visibleNodesNames) {
            gui.drawString((Component)nodeName.getSecond(), (Boolean)nodeName.getFirst() != false ? 42 : 32, y, 0x404040);
            y += 14;
        }
    }

    private List<Pair<Boolean, Component>> refactorToggleButtons() {
        ArrayList<Pair<Boolean, Component>> visibleNodes = new ArrayList<Pair<Boolean, Component>>();
        int index = 0;
        int visibleIndex = 0;
        TraderData trader = ((ITraderStorageMenu)this.menu).getTrader();
        ScreenPosition corner = ((ITraderStorageScreen)this.screen).getCorner();
        for (Pair<NodeKey, PlainButton> pair : this.toggleSwitches) {
            SettingsNode node;
            NodeKey nodeKey = (NodeKey)pair.getFirst();
            SettingsNode settingsNode = node = trader == null ? null : trader.getNode(nodeKey.node);
            if (node == null || !node.allowSelecting(((ITraderStorageMenu)this.menu).getPlayer())) {
                ((PlainButton)((Object)pair.getSecond())).setVisible(false);
                continue;
            }
            if (index < this.scroll || index >= this.scroll + 8) {
                ((PlainButton)((Object)pair.getSecond())).setVisible(false);
            } else {
                Pair nodeName;
                if (nodeKey.hasSubnode()) {
                    SettingsSubNode<?> subNode = node.getSubNode(nodeKey.subNode);
                    if (subNode == null || !subNode.allowSelecting(((ITraderStorageMenu)this.menu).getPlayer()) || !this.isNodeSelected(new NodeKey(node.key, null))) {
                        ((PlainButton)((Object)pair.getSecond())).setVisible(false);
                        continue;
                    }
                    nodeName = Pair.of((Object)true, (Object)subNode.getName());
                } else {
                    nodeName = Pair.of((Object)false, (Object)node.getName());
                }
                PlainButton toggle = (PlainButton)((Object)pair.getSecond());
                toggle.setVisible(true);
                toggle.setPosition(corner.offset((Boolean)nodeName.getFirst() != false ? 30 : 20, 8 + 14 * visibleIndex));
                visibleNodes.add((Pair<Boolean, Component>)nodeName);
                ++visibleIndex;
            }
            ++index;
        }
        return visibleNodes;
    }

    @Override
    public IconData getIcon() {
        return IconUtil.ICON_COUNT;
    }

    @Override
    @Nullable
    public Component getTooltip() {
        return LCText.TOOLTIP_TRADER_SETTINGS_CLIPBOARD.get(new Object[0]);
    }

    private boolean isNodeSelected(NodeKey key) {
        if (this.selections.nodeSelected(key.node)) {
            return !key.hasSubnode() || this.selections.subNodeSelected(key.node, key.subNode);
        }
        return false;
    }

    private void toggleNode(NodeKey key) {
        if (key.hasSubnode()) {
            this.selections.toggleSubNode(key.node, key.subNode);
        } else {
            this.selections.toggleNode(key.node);
            if (this.selections.nodeSelected(key.node)) {
                SettingsNode node;
                TraderData trader = ((ITraderStorageMenu)this.menu).getTrader();
                SettingsNode settingsNode = node = trader == null ? null : trader.getNode(key.node);
                if (node != null) {
                    for (SettingsSubNode<?> subNode : node.getSubNodes()) {
                        this.selections.addSubNode(node.key, subNode.getSubKey());
                    }
                }
            }
        }
    }

    private void tryCopy() {
        if (((SettingsClipboardTab)this.commonTab).canWriteSettingsToStack()) {
            ((SettingsClipboardTab)this.commonTab).copySettingsToStack(this.selections);
        } else {
            ((SettingsClipboardTab)this.commonTab).copySettingsDirectly(this.selections);
        }
    }

    private void tryLoad() {
        if (((SettingsClipboardTab)this.commonTab).canReadSettingsFromStack()) {
            ((SettingsClipboardTab)this.commonTab).loadSettingsFromStack(this.selections);
        } else if (this.canReadSettings()) {
            ((SettingsClipboardTab)this.commonTab).loadSettingsDirectly(this.selections, this.getClipboard());
        }
    }

    public int getVisibleNodes() {
        TraderData trader = ((ITraderStorageMenu)this.menu).getTrader();
        if (trader == null) {
            return 0;
        }
        return (int)this.toggleSwitches.stream().filter(p -> {
            NodeKey nodeKey = (NodeKey)p.getFirst();
            SettingsNode node = trader.getNode(nodeKey.node);
            if (node != null && node.allowSelecting(((ITraderStorageMenu)this.menu).getPlayer())) {
                if (nodeKey.hasSubnode()) {
                    SettingsSubNode<?> subNode = node.getSubNode(nodeKey.subNode);
                    return subNode != null && subNode.allowSelecting(((ITraderStorageMenu)this.menu).getPlayer()) && this.selections.nodeSelected(nodeKey.node);
                }
                return true;
            }
            return false;
        }).count();
    }

    @Override
    public int currentScroll() {
        return this.scroll;
    }

    @Override
    public void setScroll(int newScroll) {
        this.scroll = newScroll;
    }

    @Override
    public int getMaxScroll() {
        return IScrollable.calculateMaxScroll(8, this.getVisibleNodes());
    }

    private record NodeKey(String node, @Nullable String subNode) {
        boolean hasSubnode() {
            return this.subNode != null;
        }

        @Override
        public String toString() {
            return this.hasSubnode() ? this.node + "." + this.subNode : this.node;
        }
    }
}

