/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.core;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.capability.money.IMoneyHandler;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.misc.icons.IconData;
import io.github.lightman314.lightmanscurrency.api.misc.icons.IconUtil;
import io.github.lightman314.lightmanscurrency.api.misc.menus.MoneySlot;
import io.github.lightman314.lightmanscurrency.api.money.input.MoneyValueWidget;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.ITraderStorageMenu;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.TraderStorageClientTab;
import io.github.lightman314.lightmanscurrency.client.gui.easy.interfaces.IEasyScreen;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyAddonHelper;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyTextButton;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.TextRenderUtil;
import io.github.lightman314.lightmanscurrency.common.menus.traderstorage.core.TraderMoneyStorageTab;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;

public class TraderMoneyStorageClientTab
extends TraderStorageClientTab<TraderMoneyStorageTab> {
    private MoneyValueWidget amountWidget = null;

    public TraderMoneyStorageClientTab(Object screen, TraderMoneyStorageTab commonTab) {
        super(screen, commonTab);
    }

    @Override
    protected void initialize(ScreenArea screenArea, boolean firstOpen) {
        this.amountWidget = this.addChild(((MoneyValueWidget.Builder)MoneyValueWidget.builder().position(screenArea.centerX() - 88, screenArea.y + 10)).oldIfNotFirst(firstOpen, this.amountWidget).blockFreeInputs().build());
        this.addChild(((EasyTextButton.Builder)((EasyTextButton.Builder)((EasyTextButton.Builder)((EasyTextButton.Builder)EasyTextButton.builder().position(screenArea.pos.offset(20, 85))).width(80)).text(LCText.BUTTON_TRADER_STORE_MONEY).pressAction(this::storeMoney)).addon(EasyAddonHelper.activeCheck(this::storeButtonActive))).build());
        this.addChild(((EasyTextButton.Builder)((EasyTextButton.Builder)((EasyTextButton.Builder)((EasyTextButton.Builder)EasyTextButton.builder().position(screenArea.pos.offset(screenArea.width - 100, 85))).width(80)).text(LCText.BUTTON_TRADER_COLLECT_MONEY).pressAction(this::collectMoney)).addon(EasyAddonHelper.activeCheck(this::collectButtonActive))).build());
    }

    @Override
    public void renderBG(@Nonnull EasyGuiGraphics gui) {
        TraderData trader = ((ITraderStorageMenu)this.menu).getTrader();
        if (trader != null) {
            TextRenderUtil.drawCenteredText(gui, (Component)LCText.GUI_TRADER_MONEY_STORAGE_CONTENTS.get(trader.getInternalStoredMoney().getRandomValueText()), 103, 110, 0x404040);
        }
        for (MoneySlot slot : ((TraderMoneyStorageTab)this.commonTab).getCoinSlots()) {
            gui.renderSlot((IEasyScreen)this.screen, slot);
        }
    }

    private boolean storeButtonActive() {
        if (!((TraderMoneyStorageTab)this.commonTab).canStoreMoney()) {
            return false;
        }
        IMoneyHandler coinSlotHandler = ((TraderMoneyStorageTab)this.commonTab).getCoinSlotHandler();
        return !coinSlotHandler.getStoredMoney().isEmpty() || !this.amountWidget.getCurrentValue().isEmpty();
    }

    private boolean collectButtonActive() {
        if (!((TraderMoneyStorageTab)this.commonTab).canCollectMoney()) {
            return false;
        }
        TraderData trader = ((ITraderStorageMenu)this.menu).getTrader();
        return trader != null && !trader.getInternalStoredMoney().isEmpty();
    }

    @Override
    @Nonnull
    public IconData getIcon() {
        return IconUtil.ICON_STORE_COINS;
    }

    @Override
    @Nullable
    public Component getTooltip() {
        return LCText.TOOLTIP_TRADER_MONEY_STORAGE.get(new Object[0]);
    }

    private void storeMoney() {
        if (this.amountWidget == null) {
            return;
        }
        ((TraderMoneyStorageTab)this.commonTab).storeMoney(this.amountWidget.getCurrentValue());
        this.amountWidget.changeValue(MoneyValue.empty());
    }

    private void collectMoney() {
        if (this.amountWidget == null) {
            return;
        }
        ((TraderMoneyStorageTab)this.commonTab).collectMoney(this.amountWidget.getCurrentValue());
        this.amountWidget.changeValue(MoneyValue.empty());
    }
}

