/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.info.core;

import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.misc.icons.IconData;
import io.github.lightman314.lightmanscurrency.api.misc.icons.IconUtil;
import io.github.lightman314.lightmanscurrency.api.taxes.ITaxCollector;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.info.InfoSubTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.info.TraderInfoClientTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.ScrollListener;
import io.github.lightman314.lightmanscurrency.client.gui.widget.scroll.IScrollable;
import io.github.lightman314.lightmanscurrency.client.gui.widget.scroll.ScrollBarWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.taxes.ITaxInfoInteractable;
import io.github.lightman314.lightmanscurrency.client.gui.widget.taxes.TaxInfoWidget;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.TextRenderUtil;
import io.github.lightman314.lightmanscurrency.common.player.LCAdminMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public class TaxInfoClientTab
extends InfoSubTab
implements IScrollable,
ITaxInfoInteractable {
    public static final int DISPLAY_ENTRIES = 4;
    private int scroll = 0;

    public TaxInfoClientTab(TraderInfoClientTab tab) {
        super(tab);
    }

    @Override
    @Nonnull
    public IconData getIcon() {
        return IconUtil.ICON_TAXES;
    }

    @Override
    @Nullable
    public Component getTooltip() {
        return LCText.TOOLTIP_TRADER_TAXES.get(new Object[0]);
    }

    @Override
    public boolean canOpen() {
        return this.menu.hasPermission("editSettings");
    }

    @Override
    protected void initialize(ScreenArea screenArea, boolean firstOpen) {
        for (int i = 0; i < 4; ++i) {
            int index = i;
            this.addChild(((TaxInfoWidget.Builder)TaxInfoWidget.builder().position(screenArea.pos.offset(15, 30 * i + 20))).entry(() -> this.getEntryOfIndex(index)).parent(this).build());
        }
        this.addChild(((ScrollListener.Builder)ScrollListener.builder().area(screenArea.ofSize(screenArea.width, 120).offsetPosition(0, 10))).listener(this).build());
        this.addChild(((ScrollBarWidget.Builder)ScrollBarWidget.builder().position(screenArea.pos.offset(191, 20))).height(120).scrollable(this).build());
    }

    @Override
    public void renderBG(@Nonnull EasyGuiGraphics gui) {
        TraderData trader = this.getTrader();
        if (trader != null) {
            Pair<Integer, Integer> result = trader.getTotalTaxPercentageRange();
            if (Objects.equals(result.getFirst(), result.getSecond())) {
                TextRenderUtil.drawCenteredText(gui, (Component)LCText.GUI_TRADER_TAXES_TOTAL_RATE.get(result.getFirst()), this.screen.getXSize() / 2, 6, 0x404040);
            } else {
                TextRenderUtil.drawCenteredText(gui, (Component)LCText.GUI_TRADER_TAXES_TOTAL_RATE_RANGE.get(result.getFirst(), result.getSecond()), this.screen.getXSize() / 2, 6, 0x404040);
            }
            if (trader.getPossibleTaxes().isEmpty()) {
                TextRenderUtil.drawCenteredMultilineText(gui, (Component)LCText.GUI_TRADER_TAXES_NO_TAX_COLLECTORS.get(new Object[0]), 10, this.screen.getXSize() - 20, 60, 0x404040);
            }
        }
    }

    private List<ITaxCollector> getAllEntries() {
        TraderData trader = this.menu.getTrader();
        if (trader != null) {
            return trader.getPossibleTaxes();
        }
        return new ArrayList<ITaxCollector>();
    }

    @Nullable
    private ITaxCollector getEntryOfIndex(int index) {
        List<ITaxCollector> entries = this.getAllEntries();
        if ((index += this.scroll) < 0 || index >= entries.size()) {
            return null;
        }
        return entries.get(index);
    }

    @Override
    public void tick() {
        this.validateScroll();
    }

    @Override
    @Nullable
    public TraderData getTrader() {
        return this.menu.getTrader();
    }

    @Override
    public boolean canPlayerForceIgnore() {
        return LCAdminMode.isAdminPlayer(this.menu.getPlayer());
    }

    @Override
    public void AcceptTaxCollector(long taxEntryID) {
        this.sendMessage(this.builder().setLong("AcceptTaxCollector", taxEntryID));
    }

    @Override
    public void ForceIgnoreTaxCollector(long taxEntryID) {
        this.sendMessage(this.builder().setLong("ForceIgnoreTaxCollector", taxEntryID));
    }

    @Override
    public void PardonIgnoredTaxCollector(long taxEntryID) {
        this.sendMessage(this.builder().setLong("PardonTaxCollector", taxEntryID));
    }

    @Override
    public int currentScroll() {
        return this.scroll;
    }

    @Override
    public void setScroll(int newScroll) {
        this.scroll = newScroll;
    }

    @Override
    public int getMaxScroll() {
        return IScrollable.calculateMaxScroll(4, this.getAllEntries().size());
    }
}

