/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.variant;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.LCConfig;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.variants.item.IVariantItem;
import io.github.lightman314.lightmanscurrency.client.gui.easy.EasyMenuScreen;
import io.github.lightman314.lightmanscurrency.client.gui.widget.ModelVariantButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.ScrollListener;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyAddonHelper;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyTextButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.scroll.IScrollable;
import io.github.lightman314.lightmanscurrency.client.gui.widget.scroll.ScrollBarWidget;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.ModelVariantDataManager;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.data.DefaultModelVariant;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.data.ModelVariant;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.properties.VariantProperties;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import io.github.lightman314.lightmanscurrency.common.menus.variant.VariantSelectMenu;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public abstract class VariantSelectScreen<T extends VariantSelectMenu>
extends EasyMenuScreen<T>
implements IScrollable {
    private List<Pair<ResourceLocation, ModelVariant>> availableVariants;
    private int scroll = 0;
    private ResourceLocation selectedVariant = null;
    private Pair<ResourceLocation, ModelVariant> viewingVariant = null;

    public VariantSelectScreen(T menu, Inventory inventory, Component title) {
        super(menu, inventory);
        this.onVariantTargetChanged();
    }

    protected int getWidth() {
        return 9;
    }

    protected int getHeight() {
        return 4;
    }

    protected final void onVariantTargetChanged() {
        this.viewingVariant = null;
        if (!this.hasValidTarget()) {
            this.availableVariants = ImmutableList.of();
            return;
        }
        boolean creative = Minecraft.m_91087_().f_91074_.m_7500_();
        ArrayList<Object> temp = new ArrayList<Object>();
        temp.add(Pair.of(null, (Object)this.buildDefaultVariant()));
        for (ResourceLocation id : this.getValidVariants()) {
            ModelVariant variant;
            if (!creative && LCConfig.SERVER.variantBlacklist.matches(id) || (variant = ModelVariantDataManager.getVariant(id)) == null || !creative && variant.getOrDefault(VariantProperties.HIDDEN).booleanValue()) continue;
            temp.add(Pair.of((Object)id, (Object)variant));
        }
        temp.sort(ModelVariant.COMPARATOR);
        this.availableVariants = ImmutableList.copyOf(temp);
    }

    protected abstract boolean hasValidTarget();

    protected abstract List<ResourceLocation> getValidVariants();

    protected abstract DefaultModelVariant buildDefaultVariant();

    protected abstract ItemLike getTargetAsItem();

    @Override
    protected void initialize(ScreenArea screenArea) {
        this.addChild(((ScrollListener.Builder)ScrollListener.builder().listener(this).area(screenArea)).build());
        this.addChild(((ScrollBarWidget.Builder)ScrollBarWidget.builder().position(screenArea.pos.offset(169, 87))).height(18 * this.getHeight()).scrollable(this).build());
        int relativeIndex = 0;
        for (int y = 0; y < this.getHeight(); ++y) {
            int yPos = 103 + 18 * y;
            for (int x = 0; x < this.getWidth(); ++x) {
                int xPos = 7 + 18 * x;
                int i = relativeIndex++;
                this.addChild(((ModelVariantButton.Builder)((ModelVariantButton.Builder)ModelVariantButton.builder().target(this::getTargetAsItem).position(screenArea.pos.offset(xPos, yPos))).selected(this::selectedVariant).viewing(this::viewingVariant).pressAction(() -> this.selectVariant(i))).source(this.variantSource(i)).screen(this).build());
            }
        }
        this.addChild(((EasyTextButton.Builder)((EasyTextButton.Builder)((EasyTextButton.Builder)((EasyTextButton.Builder)EasyTextButton.builder().position(screenArea.pos.offset(83, 43))).text(LCText.BUTTON_VARIANT_SELECT).width(92)).pressAction(this::setSelectedVariant)).addon(EasyAddonHelper.activeCheck(this::canSelectCurrentVariant))).build());
    }

    protected abstract ResourceLocation getBackgroundTexture();

    @Override
    protected void renderBG(EasyGuiGraphics gui) {
        gui.renderNormalBackground(this.getBackgroundTexture(), this);
        gui.drawString((Component)LCText.GUI_VARIANT_MENU.get(new Object[0]), 8, 93, 0x404040);
        this.selectedVariant = ((VariantSelectMenu)this.f_97732_).getSelectedVariant();
        if (this.viewingVariant == null && this.hasValidTarget()) {
            for (int i = 0; this.viewingVariant == null && i < this.availableVariants.size(); ++i) {
                Pair<ResourceLocation, ModelVariant> entry = this.availableVariants.get(i);
                if (!Objects.equals(entry.getFirst(), this.selectedVariant)) continue;
                this.viewingVariant = entry;
            }
            if (this.viewingVariant == null) {
                this.viewingVariant = this.availableVariants.get(0);
            }
        }
        if (this.viewingVariant != null) {
            ModelVariant variant = (ModelVariant)this.viewingVariant.getSecond();
            gui.drawString((Component)variant.getName(), 8, 7, 0x404040);
            ItemStack item = variant.getItemIcon();
            if (item == null) {
                item = new ItemStack(this.getTargetAsItem());
                if (this.viewingVariant.getFirst() != null) {
                    IVariantItem.setItemVariant(item, (ResourceLocation)this.viewingVariant.getFirst());
                }
            }
            gui.renderScaledItem(item, ScreenPosition.of(8, 18), 4.375f);
        }
    }

    private Supplier<Pair<ResourceLocation, ModelVariant>> variantSource(int relativeIndex) {
        return () -> {
            int index = relativeIndex + this.scroll * this.getWidth();
            if (index < 0 || index >= this.availableVariants.size()) {
                return null;
            }
            return this.availableVariants.get(index);
        };
    }

    @Nullable
    private ResourceLocation selectedVariant() {
        return this.selectedVariant;
    }

    @Nullable
    private ResourceLocation viewingVariant() {
        return this.viewingVariant == null ? null : (ResourceLocation)this.viewingVariant.getFirst();
    }

    @Override
    public int currentScroll() {
        return this.scroll;
    }

    @Override
    public void setScroll(int newScroll) {
        this.scroll = newScroll;
    }

    @Override
    public int getMaxScroll() {
        return IScrollable.calculateMaxScroll(27, this.getWidth(), this.availableVariants.size());
    }

    private void selectVariant(int relativeIndex) {
        int index = relativeIndex + this.scroll * this.getWidth();
        if (index < 0 || index >= this.availableVariants.size()) {
            return;
        }
        this.viewingVariant = this.availableVariants.get(index);
    }

    private boolean canSelectCurrentVariant() {
        if (this.viewingVariant == null) {
            return false;
        }
        return !Objects.equals(this.selectedVariant, this.viewingVariant.getFirst());
    }

    private void setSelectedVariant() {
        if (this.viewingVariant == null) {
            return;
        }
        ((VariantSelectMenu)this.f_97732_).SetVariant((ResourceLocation)this.viewingVariant.getFirst());
    }
}

