/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.walletbank;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.misc.icons.IconData;
import io.github.lightman314.lightmanscurrency.api.misc.icons.ItemIcon;
import io.github.lightman314.lightmanscurrency.api.misc.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.api.money.bank.reference.BankReference;
import io.github.lightman314.lightmanscurrency.api.money.bank.reference.builtin.PlayerBankReference;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.WalletBankScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.walletbank.WalletBankTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.BankAccountSelectionWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.common.menus.wallet.WalletBankMenu;
import io.github.lightman314.lightmanscurrency.network.message.bank.CPacketSelectBankAccount;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class SelectionTab
extends WalletBankTab {
    BankAccountSelectionWidget bankAccountSelection;

    public SelectionTab(WalletBankScreen screen) {
        super(screen);
    }

    @Override
    @Nonnull
    public IconData getIcon() {
        return ItemIcon.ofItem((ItemLike)Items.f_42516_);
    }

    public MutableComponent getTooltip() {
        return LCText.TOOLTIP_ATM_SELECTION.get(new Object[0]);
    }

    @Override
    public void initialize(ScreenArea screenArea, boolean firstOpen) {
        this.bankAccountSelection = this.addChild(((BankAccountSelectionWidget.Builder)BankAccountSelectionWidget.builder().position(screenArea.pos.offset(20, 15))).width(screenArea.width - 40).rows(4).filter(this::allowedAccess).selected(((WalletBankMenu)this.menu)::getBankAccountReference).handler(this::selectAccount).build());
    }

    @Override
    public boolean blockInventoryClosing() {
        return true;
    }

    private boolean allowedAccess(@Nonnull BankReference reference) {
        return reference.allowedAccess(PlayerReference.of(((WalletBankMenu)this.menu).player));
    }

    private void selectAccount(@Nonnull BankReference reference) {
        new CPacketSelectBankAccount(reference).send();
    }

    private void PressPersonalAccount(EasyButton button) {
        BankReference account = PlayerBankReference.of(((WalletBankMenu)((WalletBankScreen)this.screen).m_6262_()).getPlayer());
        new CPacketSelectBankAccount(account).send();
    }

    @Override
    public void renderBG(@Nonnull EasyGuiGraphics gui) {
        gui.drawString((Component)this.getTooltip(), 8, 6, 0x404040);
    }
}

