/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.widget.button.tab;

import io.github.lightman314.lightmanscurrency.api.misc.client.sprites.FixedSizeSprite;
import io.github.lightman314.lightmanscurrency.api.misc.client.sprites.builtin.WidgetStateSprite;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.WidgetRotation;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;

public class TabSpriteSource
implements Function<WidgetRotation, FixedSizeSprite> {
    private final Map<WidgetRotation, FixedSizeSprite> cache = new HashMap<WidgetRotation, FixedSizeSprite>();
    private final Function<WidgetRotation, ResourceLocation> fileBuilder;
    private final int size;

    public TabSpriteSource(Function<WidgetRotation, ResourceLocation> fileBuilder, int size) {
        this.fileBuilder = fileBuilder;
        this.size = size;
    }

    public static TabSpriteSource create(Function<String, ResourceLocation> fileBuilder, int size) {
        return new TabSpriteSource(rot -> (ResourceLocation)fileBuilder.apply(rot.name().toLowerCase(Locale.ENGLISH)), size);
    }

    public static TabSpriteSource createBuiltin(String name, int size) {
        return TabSpriteSource.create(rot -> VersionUtil.lcResource(name + "_" + rot), size);
    }

    @Override
    public FixedSizeSprite apply(WidgetRotation rotation) {
        if (!this.cache.containsKey((Object)rotation)) {
            this.cache.put(rotation, WidgetStateSprite.lazyActive(this.fileBuilder.apply(rotation), this.size, this.size));
        }
        return this.cache.get((Object)rotation);
    }
}

