/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.renderer.blockentity;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.lightman314.lightmanscurrency.client.renderer.ItemRenderHelper;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.item_trader.item_positions.ItemPositionBlockManager;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.item_trader.item_positions.ItemPositionData;
import io.github.lightman314.lightmanscurrency.common.blockentity.AuctionStandBlockEntity;
import java.util.List;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class AuctionStandBlockEntityRenderer
implements BlockEntityRenderer<AuctionStandBlockEntity> {
    private final ItemRenderer itemRenderer;

    private AuctionStandBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.itemRenderer = context.m_234447_();
    }

    public static AuctionStandBlockEntityRenderer create(BlockEntityRendererProvider.Context context) {
        return new AuctionStandBlockEntityRenderer(context);
    }

    public void render(@NotNull AuctionStandBlockEntity blockEntity, float partialTicks, @NotNull PoseStack pose, @NotNull MultiBufferSource buffer, int lightLevel, int id) {
        ImmutableList<ItemStack> displayItems = AuctionStandBlockEntity.getDisplayItems();
        if (displayItems.isEmpty()) {
            return;
        }
        BlockState state = blockEntity.m_58900_();
        ItemPositionData data = ItemPositionBlockManager.getDataForBlock(state);
        List<Vector3f> positions = data.getPositions(state, 0);
        if (positions.isEmpty()) {
            return;
        }
        pose.m_85836_();
        Vector3f pos = positions.get(0);
        pose.m_252880_(pos.x, pos.y, pos.z);
        for (Quaternionf r : data.getRotation(state, 0, partialTicks)) {
            pose.m_252781_(r);
        }
        float scale = data.getScale(0);
        pose.m_85841_(scale, scale, scale);
        int itemLight = lightLevel;
        Level level = blockEntity.m_58904_();
        BlockPos blockPos = blockEntity.m_58899_();
        int minLight = data.getMinLight(0);
        if (level.m_45517_(LightLayer.BLOCK, blockPos) < minLight) {
            itemLight = LightTexture.m_109885_((int)Math.min(minLight, level.m_7469_()), (int)level.m_45517_(LightLayer.SKY, blockPos));
        }
        if (displayItems.size() < 2) {
            ItemRenderHelper.renderItem(blockEntity, this.itemRenderer, (ItemStack)displayItems.get(0), itemLight, pose, buffer, id);
        } else {
            pose.m_85836_();
            pose.m_252880_(-0.55f, 0.0f, 0.0f);
            ItemRenderHelper.renderItem(blockEntity, this.itemRenderer, (ItemStack)displayItems.get(0), itemLight, pose, buffer, id);
            pose.m_85849_();
            pose.m_85836_();
            pose.m_252880_(0.55f, 0.0f, 0.0f);
            ItemRenderHelper.renderItem(blockEntity, this.itemRenderer, (ItemStack)displayItems.get(1), itemLight, pose, buffer, id);
            pose.m_85849_();
        }
        pose.m_85849_();
    }
}

