/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import io.github.lightman314.lightmanscurrency.api.variants.VariantProvider;
import io.github.lightman314.lightmanscurrency.api.variants.item.IVariantItem;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.ModelVariantDataManager;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.data.ModelVariant;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.models.VariantModelLocation;
import io.github.lightman314.lightmanscurrency.common.capability.wallet.IWalletHandler;
import io.github.lightman314.lightmanscurrency.common.capability.wallet.WalletCapability;
import io.github.lightman314.lightmanscurrency.common.items.WalletItem;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class WalletLayer<T extends LivingEntity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    public WalletLayer(RenderLayerParent<T, M> renderer) {
        super(renderer);
    }

    public void render(@Nonnull PoseStack pose, @Nonnull MultiBufferSource bufferSource, int light, @Nonnull T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        IWalletHandler handler = WalletCapability.lazyGetWalletHandler(entity);
        if (handler == null || !handler.visible()) {
            return;
        }
        ItemStack wallet = handler.getVisibleWallet();
        Item item = wallet.m_41720_();
        if (item instanceof WalletItem) {
            WalletItem walletItem = (WalletItem)item;
            pose.m_85836_();
            pose.m_252781_(MathUtil.fromAxisAngleDegree(MathUtil.getZP(), 180.0f));
            pose.m_252880_(0.125f, -0.46875f, 0.375f);
            Minecraft mc = Minecraft.m_91087_();
            BakedModel model = WalletLayer.getWalletModel(wallet, mc, walletItem);
            mc.m_91291_().m_115143_(wallet, ItemDisplayContext.FIXED, false, pose, bufferSource, light, OverlayTexture.f_118083_, model);
            pose.m_85849_();
        }
    }

    private static BakedModel getWalletModel(ItemStack wallet, Minecraft mc, WalletItem w) {
        VariantModelLocation modelID;
        ModelVariant variant;
        ResourceLocation variantID;
        IVariantItem variantItem = VariantProvider.getVariantItem(wallet);
        if (variantItem != null && (variantID = IVariantItem.getItemVariant(wallet)) != null && (variant = ModelVariantDataManager.getVariant(variantID)) != null && variant.isValidTarget(wallet) && (modelID = VariantModelLocation.basic(variantID, variantItem.getItemID(), 0)) != null) {
            return ModelVariantDataManager.getModel(modelID);
        }
        return mc.m_91304_().getModel(w.model);
    }
}

