/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.data.types;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.misc.data.CustomData;
import io.github.lightman314.lightmanscurrency.api.misc.data.CustomDataType;
import io.github.lightman314.lightmanscurrency.api.misc.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.api.money.bank.reference.BankReference;
import io.github.lightman314.lightmanscurrency.api.money.bank.reference.builtin.PlayerBankReference;
import io.github.lightman314.lightmanscurrency.api.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.common.bank.BankAccount;
import io.github.lightman314.lightmanscurrency.network.message.bank.CPacketSelectBankAccount;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.FieldsAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.server.ServerLifecycleHooks;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class BankDataCache
extends CustomData {
    public static final CustomDataType<BankDataCache> TYPE = new CustomDataType<BankDataCache>("lightmanscurrency_bank_data", BankDataCache::new);
    private final Map<UUID, BankDataEntry> playerBankData = new HashMap<UUID, BankDataEntry>();
    private int interestTick = 0;

    private BankDataCache() {
    }

    @Override
    public CustomDataType<?> getType() {
        return TYPE;
    }

    @Override
    public void save(CompoundTag tag) {
        ListTag bankData = new ListTag();
        this.playerBankData.forEach((player, data) -> {
            CompoundTag entry = new CompoundTag();
            entry.m_128362_("Player", player);
            entry.m_128365_("BankAccount", (Tag)data.account.save());
            entry.m_128365_("LastSelected", (Tag)data.selected.save());
            bankData.add((Object)entry);
        });
        tag.m_128365_("PlayerBankData", (Tag)bankData);
        tag.m_128405_("InterestTick", this.interestTick);
    }

    @Override
    protected void load(CompoundTag tag) {
        ListTag bankData = tag.m_128437_("PlayerBankData", 10);
        for (int i = 0; i < bankData.size(); ++i) {
            CompoundTag entry = bankData.m_128728_(i);
            UUID player = entry.m_128342_("Player");
            BankAccount bankAccount = this.loadBankAccount(player, entry.m_128469_("BankAccount"));
            BankReference lastSelected = BankReference.load(entry.m_128469_("LastSelected"));
            this.playerBankData.put(player, new BankDataEntry(bankAccount, lastSelected));
        }
        if (tag.m_128441_("InterestTick")) {
            this.interestTick = tag.m_128451_("InterestTick");
        }
    }

    private BankAccount loadBankAccount(UUID player, CompoundTag compound) {
        BankAccount bankAccount = new BankAccount(() -> this.markAccountDirty(player), compound);
        try {
            bankAccount.setNotificationConsumer(BankAccount.generateNotificationAcceptor(player));
            bankAccount.updateOwnersName(PlayerReference.of(player, bankAccount.getOwnersName()).getName(false));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return bankAccount;
    }

    private BankAccount generateBankAccount(UUID player) {
        BankAccount bankAccount = new BankAccount(() -> this.markAccountDirty(player));
        try {
            bankAccount.setNotificationConsumer(BankAccount.generateNotificationAcceptor(player));
            bankAccount.updateOwnersName(PlayerReference.of(player, bankAccount.getOwnersName()).getName(this.isClient()));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return bankAccount;
    }

    public List<BankReference> getPlayerBankAccounts() {
        ArrayList<BankReference> results = new ArrayList<BankReference>();
        for (UUID player : this.playerBankData.keySet()) {
            results.add(PlayerBankReference.of(player).flagAsClient(this));
        }
        return results;
    }

    public boolean hasAccount(UUID player) {
        return this.playerBankData.containsKey(player);
    }

    public BankAccount getAccount(Player player) {
        return this.getAccount(player.m_20148_());
    }

    public BankAccount getAccount(UUID player) {
        if (this.playerBankData.containsKey(player)) {
            return this.playerBankData.get((Object)player).account;
        }
        BankAccount newAccount = this.generateBankAccount(player);
        this.playerBankData.put(player, new BankDataEntry(newAccount, PlayerBankReference.of(player).flagAsClient(this)));
        this.markAccountDirty(player);
        return newAccount;
    }

    public boolean deleteAccount(UUID player) {
        if (this.isClient()) {
            LightmansCurrency.LogWarning("Cannot delete a bank account from the logical client!");
            return false;
        }
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server == null) {
            return false;
        }
        if (!this.playerBankData.containsKey(player)) {
            return false;
        }
        ServerPlayer onlinePlayer = server.m_6846_().m_11259_(player);
        this.playerBankData.remove(player);
        if (onlinePlayer != null) {
            this.getAccount(player);
            this.syncSelectedAccount(onlinePlayer);
        } else {
            this.setChanged();
            this.sendSyncPacket(this.builder().setUUID("DeleteAccount", player));
        }
        return true;
    }

    public void markAccountDirty(UUID playerID) {
        this.setChanged();
        this.syncBankAccount(playerID);
    }

    private void syncBankAccount(UUID player) {
        this.syncBankAccount(player, null);
    }

    private void syncBankAccount(UUID player, @Nullable ServerPlayer target) {
        BankAccount account = this.getAccount(player);
        LazyPacketData.Builder packet = this.builder().setUUID("UpdateAccount", player).setCompound("Account", account.save());
        if (target == null) {
            this.sendSyncPacket(packet);
        } else {
            this.sendSyncPacket(packet, target);
        }
    }

    public BankReference getSelectedAccount(Player player) {
        if (this.playerBankData.containsKey(player.m_20148_())) {
            BankReference account = this.playerBankData.get((Object)player.m_20148_()).selected;
            if (!account.allowedAccess(player)) {
                LightmansCurrency.LogInfo(player.m_7755_().getString() + " is no longer allowed to access their selected bank account. Switching back to their personal account.");
                account = PlayerBankReference.of(player).flagAsClient(this);
                this.setSelectedAccount(player, account);
            }
            return account;
        }
        BankReference account = PlayerBankReference.of(player).flagAsClient(this);
        this.setSelectedAccount(player, account);
        return account;
    }

    public void setSelectedAccount(Player player, BankReference account) {
        if (account == null) {
            return;
        }
        if (this.isClient()) {
            if (!LightmansCurrency.getProxy().isSelf(player)) {
                return;
            }
            new CPacketSelectBankAccount(account).send();
            return;
        }
        if (!account.allowedAccess(player)) {
            LightmansCurrency.LogInfo("Player does not have access to the selected account. Canceling selection.");
            return;
        }
        BankDataEntry data = this.playerBankData.get(player.m_20148_());
        if (data == null) {
            data = new BankDataEntry(this.generateBankAccount(player.m_20148_()), null);
            this.syncBankAccount(player.m_20148_());
        }
        data.selected = account;
        this.setChanged();
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            this.syncSelectedAccount(sp);
        }
    }

    private void syncSelectedAccount(ServerPlayer player) {
        this.sendSyncPacket(this.builder().setUUID("UpdateSelected", player.m_20148_()).setCompound("Selected", this.getSelectedAccount((Player)player).save()), player);
    }

    @Override
    protected void parseSyncPacket(LazyPacketData message) {
        BankDataEntry data;
        UUID account;
        if (message.contains("ClearAccounts")) {
            this.playerBankData.clear();
        }
        if (message.contains("DeleteAccount")) {
            this.playerBankData.remove(message.getUUID("DeleteAccount"));
        }
        if (message.contains("UpdateAccount")) {
            account = message.getUUID("UpdateAccount");
            BankAccount ba = this.loadBankAccount(account, message.getNBT("Account")).flagAsClient(this);
            data = this.playerBankData.containsKey(account) ? this.playerBankData.get(account) : new BankDataEntry(null, PlayerBankReference.of(account).flagAsClient(this));
            data.account = ba;
            this.playerBankData.put(account, data);
        }
        if (message.contains("UpdateSelected")) {
            account = message.getUUID("UpdateSelected");
            BankReference selected = BankReference.load(message.getNBT("Selected")).flagAsClient(this);
            data = this.playerBankData.containsKey(account) ? this.playerBankData.get(account) : new BankDataEntry(this.generateBankAccount(account).flagAsClient(this), null);
            data.selected = selected;
            this.playerBankData.put(account, data);
        }
    }

    @Override
    public void onPlayerJoin(ServerPlayer player) {
        for (UUID p : this.playerBankData.keySet()) {
            this.syncBankAccount(p, player);
        }
        this.getAccount((Player)player);
        this.syncSelectedAccount(player);
    }

    public int interestTick() {
        this.setChanged();
        return this.interestTick++;
    }

    public void resetInterestTick() {
        this.interestTick = 0;
        this.setChanged();
    }

    private static class BankDataEntry {
        BankAccount account;
        BankReference selected;

        BankDataEntry(BankAccount account, BankReference selected) {
            this.account = account;
            this.selected = selected;
        }
    }
}

