/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.loot.entries;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import io.github.lightman314.lightmanscurrency.common.core.ModLootPoolEntryTypes;
import io.github.lightman314.lightmanscurrency.common.loot.ConfigItemTier;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryType;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class ConfigLoot
extends LootPoolSingletonContainer {
    private final ConfigItemTier tier;

    protected ConfigLoot(ConfigItemTier tier, int weight, int quality, LootItemCondition[] conditions, LootItemFunction[] functions) {
        super(weight, quality, conditions, functions);
        this.tier = tier;
    }

    protected void m_6948_(@Nonnull Consumer<ItemStack> consumer, @Nonnull LootContext context) {
        consumer.accept(new ItemStack((ItemLike)this.tier.getItem()));
    }

    @Nonnull
    public LootPoolEntryType m_6751_() {
        return ModLootPoolEntryTypes.LOOT_TIER_TYPE.get();
    }

    public static LootPoolSingletonContainer.Builder<?> lootTableTier(@Nonnull ConfigItemTier tier) {
        return ConfigLoot.m_79687_((p_79583_, p_79584_, p_79585_, p_79586_) -> new ConfigLoot(tier, p_79583_, p_79584_, p_79585_, p_79586_));
    }

    public static class Serializer
    extends LootPoolSingletonContainer.Serializer<ConfigLoot> {
        public void serializeCustom(@Nonnull JsonObject json, @Nonnull ConfigLoot entry, @Nonnull JsonSerializationContext context) {
            super.m_7219_(json, (LootPoolSingletonContainer)entry, context);
            json.addProperty("tier", (Number)entry.tier.tier);
        }

        @Nonnull
        protected ConfigLoot deserialize(@Nonnull JsonObject json, @Nonnull JsonDeserializationContext context, int weight, int quality, @Nonnull LootItemCondition[] conditions, @Nonnull LootItemFunction[] functions) {
            int tierNum = GsonHelper.m_13927_((JsonObject)json, (String)"tier");
            ConfigItemTier tier = ConfigItemTier.get(tierNum);
            if (tier == null) {
                throw new JsonSyntaxException("Tier must be a valid number between 1 and 6!");
            }
            return new ConfigLoot(tier, weight, quality, conditions, functions);
        }
    }
}

