/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.menus.traderstorage.slot_machine;

import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.ITraderStorageMenu;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.TraderStorageTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.slot_machine.SlotMachinePriceClientTab;
import io.github.lightman314.lightmanscurrency.common.traders.slot_machine.SlotMachineTraderData;
import javax.annotation.Nonnull;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SlotMachinePriceTab
extends TraderStorageTab {
    public SlotMachinePriceTab(@Nonnull ITraderStorageMenu menu) {
        super(menu);
    }

    @Override
    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public Object createClientTab(@Nonnull Object screen) {
        return new SlotMachinePriceClientTab(screen, this);
    }

    @Override
    public boolean canOpen(Player player) {
        return ((ITraderStorageMenu)this.menu).hasPermission("editTrades");
    }

    public void SetPrice(MoneyValue newPrice) {
        TraderData traderData;
        if (((ITraderStorageMenu)this.menu).hasPermission("editTrades") && (traderData = ((ITraderStorageMenu)this.menu).getTrader()) instanceof SlotMachineTraderData) {
            SlotMachineTraderData trader = (SlotMachineTraderData)traderData;
            trader.setPrice(newPrice);
            if (((ITraderStorageMenu)this.menu).isClient()) {
                ((ITraderStorageMenu)this.menu).SendMessage(this.builder().setMoneyValue("SetPrice", newPrice));
            }
        }
    }

    @Override
    public void receiveMessage(LazyPacketData message) {
        if (message.contains("SetPrice")) {
            this.SetPrice(message.getMoneyValue("SetPrice"));
        }
    }
}

