/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.menus.validation;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.menus.validation.MenuValidatorType;
import io.github.lightman314.lightmanscurrency.common.menus.validation.types.SimpleValidator;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public abstract class MenuValidator {
    public final MenuValidatorType type;
    public boolean isThroughNetwork = false;

    protected MenuValidator(MenuValidatorType type) {
        this.type = type;
    }

    public final void encode(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.type.type.toString());
        this.encodeAdditional(buffer);
        buffer.writeBoolean(this.isThroughNetwork);
    }

    protected abstract void encodeAdditional(FriendlyByteBuf var1);

    public final boolean isNull() {
        return this == SimpleValidator.NULL;
    }

    public final void save() {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag);
        tag.m_128359_("Type", this.type.type.toString());
        if (this.isThroughNetwork) {
            tag.m_128365_("NetworkAccess", (Tag)new CompoundTag());
        }
    }

    protected abstract void saveAdditional(CompoundTag var1);

    public abstract boolean stillValid(Player var1);

    public static MenuValidator decode(FriendlyByteBuf buffer) {
        try {
            ResourceLocation type = VersionUtil.parseResource(buffer.m_130277_());
            MenuValidatorType decoder = MenuValidatorType.getType(type);
            if (decoder != null) {
                MenuValidator result = decoder.decode(buffer);
                result.isThroughNetwork = buffer.readBoolean();
                return result;
            }
            LightmansCurrency.LogError("Could not decode MenuValidator of type '" + type + "'!");
            return SimpleValidator.NULL;
        }
        catch (Throwable t) {
            LightmansCurrency.LogError("Error decoding MenuValidator!");
            return SimpleValidator.NULL;
        }
    }

    public static MenuValidator load(CompoundTag tag) {
        try {
            ResourceLocation type = VersionUtil.parseResource(tag.m_128461_("Type"));
            MenuValidatorType decoder = MenuValidatorType.getType(type);
            if (decoder != null) {
                MenuValidator result = decoder.load(tag);
                result.isThroughNetwork = tag.m_128441_("NetworkAccess");
                return result;
            }
            LightmansCurrency.LogError("Could not load MenuValidator of type '" + type + "'!");
            return SimpleValidator.NULL;
        }
        catch (Throwable t) {
            LightmansCurrency.LogError("Error loading MenuValidator!");
            return SimpleValidator.NULL;
        }
    }
}

