/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.menus.variant;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.variants.VariantProvider;
import io.github.lightman314.lightmanscurrency.api.variants.item.IVariantItem;
import io.github.lightman314.lightmanscurrency.common.core.ModMenus;
import io.github.lightman314.lightmanscurrency.common.menus.providers.EasyMenuProvider;
import io.github.lightman314.lightmanscurrency.common.menus.variant.ItemVariantSlot;
import io.github.lightman314.lightmanscurrency.common.menus.variant.VariantSelectMenu;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class ItemVariantSelectMenu
extends VariantSelectMenu {
    private final ItemVariantSlot variantSlot = new ItemVariantSlot(155, 72);

    public ItemVariantSelectMenu(int id, Inventory inventory) {
        super(ModMenus.VARIANT_SELECT_ITEM.get(), id, inventory);
        this.m_38897_(this.variantSlot);
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.m_38897_(new Slot((Container)inventory, x + y * 9 + 9, 11 + x * 18, 154 + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.m_38897_(new Slot((Container)inventory, x, 11 + x * 18, 212));
        }
    }

    public ItemStack getVariantStack() {
        return this.variantSlot.m_7993_().m_41777_();
    }

    private boolean validSlotItem() {
        return VariantProvider.getVariantItem(this.variantSlot.m_7993_().m_41720_()) != null;
    }

    @Override
    protected void changeVariant(@Nullable ResourceLocation newVariant) {
        ItemStack variantItem = this.variantSlot.m_7993_();
        if (variantItem.m_41619_()) {
            return;
        }
        if (IVariantItem.isLocked(variantItem) && !this.player.m_7500_()) {
            LightmansCurrency.LogDebug(this.player.m_7755_().getString() + " attempted to change the variant of a locked item!");
            return;
        }
        IVariantItem.setItemVariant(variantItem, newVariant);
    }

    @Override
    @Nullable
    public ResourceLocation getSelectedVariant() {
        if (this.validSlotItem()) {
            return IVariantItem.getItemVariant(this.variantSlot.m_7993_());
        }
        return null;
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack clickedStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            clickedStack = slotStack.m_41777_();
            if (index < 1 ? !this.m_38903_(slotStack, 1, this.f_38839_.size(), true) : !this.m_38903_(slotStack, 0, 1, false)) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return clickedStack;
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        this.m_150411_(player, this.variantSlot.container);
    }

    public static MenuProvider providerFor() {
        return Provider.INSTANCE;
    }

    private static class Provider
    implements EasyMenuProvider {
        private static final Provider INSTANCE = new Provider();

        private Provider() {
        }

        @Nullable
        public AbstractContainerMenu m_7208_(int containerId, Inventory playerInventory, Player player) {
            return new ItemVariantSelectMenu(containerId, playerInventory);
        }
    }
}

