/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.util;

import io.github.lightman314.lightmanscurrency.api.misc.icons.IconData;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import org.lwjgl.system.NonnullDefault;

@NonnullDefault
public class TagUtil {
    public static CompoundTag saveBlockPos(BlockPos pos) {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("x", pos.m_123341_());
        tag.m_128405_("y", pos.m_123342_());
        tag.m_128405_("z", pos.m_123343_());
        return tag;
    }

    public static BlockPos loadBlockPos(CompoundTag tag) {
        return new BlockPos(tag.m_128451_("x"), tag.m_128451_("y"), tag.m_128451_("z"));
    }

    public static ListTag writeStringList(List<String> list) {
        ListTag result = new ListTag();
        for (String value : list) {
            result.add((Object)StringTag.m_129297_((String)value));
        }
        return result;
    }

    public static List<String> loadStringList(ListTag list) {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            result.add(list.m_128778_(i));
        }
        return result;
    }

    public static ListTag writeUUIDList(List<UUID> list) {
        ListTag result = new ListTag();
        for (UUID value : list) {
            result.add((Object)NbtUtils.m_129226_((UUID)value));
        }
        return result;
    }

    public static List<UUID> readUUIDList(ListTag list) {
        ArrayList<UUID> result = new ArrayList<UUID>();
        for (Tag tag : list) {
            result.add(NbtUtils.m_129233_((Tag)tag));
        }
        return result;
    }

    public static ListTag writeIconList(NonNullList<IconData> list) {
        ListTag iconList = new ListTag();
        for (IconData icon : list) {
            iconList.add((Object)icon.save());
        }
        return iconList;
    }

    public static void readIconList(NonNullList<IconData> list, ListTag listTag, IconData defaultIcon) {
        list.clear();
        for (int i = 0; i < list.size() && i < listTag.size(); ++i) {
            list.set(i, (Object)IconData.safeLoad(listTag.m_128728_(i), defaultIcon));
        }
    }

    public static String writeModelResource(ModelResourceLocation modelID) {
        if (modelID.m_119448_().equals("standalone")) {
            return VersionUtil.modResource(modelID.m_135827_(), modelID.m_135815_()).toString();
        }
        return modelID.toString();
    }

    public static ModelResourceLocation readModelResource(String modelID) {
        if (modelID.contains("#")) {
            String[] split = modelID.split("#", 2);
            return new ModelResourceLocation(VersionUtil.parseResource(split[0]), split[1]);
        }
        return new ModelResourceLocation(VersionUtil.parseResource(modelID), "standalone");
    }
}

