/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.integration.claiming.bonus_data;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.server.ServerLifecycleHooks;

public class LCBonusClaimData
extends SavedData {
    private final List<PlayerData> bonusClaimData = new ArrayList<PlayerData>();

    private LCBonusClaimData() {
    }

    private LCBonusClaimData(@Nonnull CompoundTag tag) {
        ListTag dataList = tag.m_128437_("BonusClaims", 10);
        for (int i = 0; i < dataList.size(); ++i) {
            CompoundTag data = dataList.m_128728_(i);
            PlayerData playerData = new PlayerData(data.m_128342_("ID"));
            playerData.bonusClaims = data.m_128451_("Claims");
            playerData.bonusLoads = data.m_128451_("ChunkLoads");
            this.bonusClaimData.add(playerData);
        }
    }

    @Nonnull
    public CompoundTag m_7176_(@Nonnull CompoundTag tag) {
        ListTag dataList = new ListTag();
        for (PlayerData pd : this.bonusClaimData) {
            if (pd.bonusClaims == 0) continue;
            CompoundTag data = new CompoundTag();
            data.m_128362_("ID", pd.playerID);
            data.m_128405_("Claims", pd.bonusClaims);
            data.m_128405_("ChunkLoads", pd.bonusLoads);
            dataList.add((Object)data);
        }
        tag.m_128365_("BonusClaims", (Tag)dataList);
        return tag;
    }

    public static int getBonusClaimsFor(Player player) {
        if (player == null) {
            return 0;
        }
        LCBonusClaimData data = LCBonusClaimData.get();
        if (data != null) {
            for (PlayerData pd : data.bonusClaimData) {
                if (!pd.matches(player)) continue;
                return pd.bonusClaims;
            }
        }
        return 0;
    }

    public static int getBonusChunkLoadsFor(Player player) {
        if (player == null) {
            return 0;
        }
        LCBonusClaimData data = LCBonusClaimData.get();
        if (data != null) {
            for (PlayerData pd : data.bonusClaimData) {
                if (!pd.matches(player)) continue;
                return pd.bonusLoads;
            }
        }
        return 0;
    }

    public static void addBonusClaimsFor(Player player, int amount) {
        if (player == null) {
            return;
        }
        LCBonusClaimData data = LCBonusClaimData.get();
        if (data != null) {
            for (PlayerData pd : data.bonusClaimData) {
                if (!pd.matches(player)) continue;
                pd.bonusClaims += amount;
                data.m_77762_();
                return;
            }
            PlayerData newData = new PlayerData(player.m_20148_());
            data.bonusClaimData.add(newData);
            newData.bonusClaims = amount;
            data.m_77762_();
        }
    }

    public static void addBonusChunkLoadsFor(Player player, int amount) {
        if (player == null) {
            return;
        }
        LCBonusClaimData data = LCBonusClaimData.get();
        if (data != null) {
            for (PlayerData pd : data.bonusClaimData) {
                if (!pd.matches(player)) continue;
                pd.bonusLoads += amount;
                data.m_77762_();
                return;
            }
            PlayerData newData = new PlayerData(player.m_20148_());
            data.bonusClaimData.add(newData);
            newData.bonusLoads = amount;
            data.m_77762_();
        }
    }

    private static LCBonusClaimData get() {
        ServerLevel level;
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null && (level = server.m_129880_(Level.f_46428_)) != null) {
            return (LCBonusClaimData)level.m_8895_().m_164861_(LCBonusClaimData::new, LCBonusClaimData::new, "lightmanscurrency_cadmus_data");
        }
        return null;
    }

    private static class PlayerData {
        final UUID playerID;
        int bonusClaims = 0;
        int bonusLoads = 0;

        PlayerData(@Nonnull UUID playerID) {
            this.playerID = playerID;
        }

        boolean matches(@Nonnull Player player) {
            return this.playerID.equals(player.m_20148_());
        }
    }
}

