/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.persistentdata;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.data.types.TraderDataCache;
import io.github.lightman314.lightmanscurrency.common.player.LCAdminMode;
import io.github.lightman314.lightmanscurrency.common.traders.auction.tradedata.AuctionTradeData;
import io.github.lightman314.lightmanscurrency.network.packet.ClientToServerPacket;
import io.github.lightman314.lightmanscurrency.network.packet.CustomPacket;
import java.util.ArrayList;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class CPacketCreatePersistentAuction
extends ClientToServerPacket {
    public static final CustomPacket.Handler<CPacketCreatePersistentAuction> HANDLER = new H();
    private static final String GENERATE_ID_FORMAT = "auction_";
    final CompoundTag auctionData;
    final String id;

    public CPacketCreatePersistentAuction(CompoundTag auctionData, String id) {
        this.auctionData = auctionData;
        this.id = id;
    }

    private JsonObject getAuctionJson(String id) {
        AuctionTradeData auction = new AuctionTradeData(this.auctionData);
        JsonObject json = new JsonObject();
        json.addProperty("id", id);
        json = auction.saveToJson(json);
        return json;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130079_(this.auctionData);
        buffer.m_130070_(this.id);
    }

    private static class H
    extends CustomPacket.Handler<CPacketCreatePersistentAuction> {
        private H() {
        }

        @Override
        public CPacketCreatePersistentAuction decode(FriendlyByteBuf buffer) {
            return new CPacketCreatePersistentAuction(buffer.m_130261_(), buffer.m_130277_());
        }

        @Override
        protected void handle(CPacketCreatePersistentAuction message, Player player) {
            if (LCAdminMode.isAdminPlayer(player)) {
                TraderDataCache data = TraderDataCache.TYPE.get(false);
                if (data == null) {
                    return;
                }
                boolean generateID = message.id.isBlank();
                if (!generateID) {
                    JsonObject auctionJson = message.getAuctionJson(message.id);
                    JsonArray persistentAuctions = data.getPersistentTraderJson("Auctions");
                    for (int i = 0; i < persistentAuctions.size(); ++i) {
                        JsonObject auctionData = persistentAuctions.get(i).getAsJsonObject();
                        if (!auctionData.has("id") || !auctionData.get("id").getAsString().equals(message.id)) continue;
                        persistentAuctions.set(i, (JsonElement)auctionJson);
                        data.setPersistentTraderSection("Auctions", persistentAuctions);
                        player.m_213846_((Component)LCText.MESSAGE_PERSISTENT_AUCTION_OVERWRITE.get(message.id));
                        return;
                    }
                    persistentAuctions.add((JsonElement)auctionJson);
                    data.setPersistentTraderSection("Auctions", persistentAuctions);
                    player.m_213846_((Component)LCText.MESSAGE_PERSISTENT_AUCTION_ADD.get(message.id));
                } else {
                    int i;
                    ArrayList<String> knownIDs = new ArrayList<String>();
                    JsonArray persistentAuctions = data.getPersistentTraderJson("Auctions");
                    for (i = 0; i < persistentAuctions.size(); ++i) {
                        JsonObject auctionData = persistentAuctions.get(i).getAsJsonObject();
                        if (!auctionData.has("id")) continue;
                        knownIDs.add(auctionData.get("id").getAsString());
                    }
                    for (i = 1; i < Integer.MAX_VALUE; ++i) {
                        String genID = CPacketCreatePersistentAuction.GENERATE_ID_FORMAT + i;
                        if (!knownIDs.stream().noneMatch(id -> id.equals(genID))) continue;
                        persistentAuctions.add((JsonElement)message.getAuctionJson(genID));
                        data.setPersistentTraderSection("Auctions", persistentAuctions);
                        player.m_213846_((Component)LCText.MESSAGE_PERSISTENT_AUCTION_ADD.get(genID));
                        return;
                    }
                    LightmansCurrency.LogError("Could not generate ID, as all auction_# ID's are somehow spoken for.");
                }
            } else if (player != null) {
                player.m_213846_((Component)LCText.MESSAGE_PERSISTENT_AUCTION_FAIL.get(new Object[0]));
            }
        }
    }
}

