/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.util;

import java.text.DecimalFormat;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class NumberUtil {
    public static String GetPrettyString(int count) {
        return new DecimalFormat().format(count);
    }

    public static boolean IsIntegerOrEmpty(String text) {
        return text.isEmpty() || NumberUtil.IsInteger(text);
    }

    public static boolean IsInteger(String text) {
        if (text == null) {
            return false;
        }
        try {
            int n = Integer.parseInt(text);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    @Nullable
    public static Integer GetIntegerValue(String text, @Nullable Integer defaultValue) {
        if (NumberUtil.IsInteger(text)) {
            return Integer.parseInt(text);
        }
        return defaultValue;
    }

    public static boolean IsLongOrEmpty(String text) {
        return text.isEmpty() || NumberUtil.IsLong(text);
    }

    public static boolean IsLong(String text) {
        if (text == null) {
            return false;
        }
        try {
            long l = Long.parseLong(text);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    @Nullable
    public static Long GetLongValue(String text, @Nullable Long defaultValue) {
        if (NumberUtil.IsLong(text)) {
            return Long.parseLong(text);
        }
        return defaultValue;
    }

    public static boolean IsFloatOrEmpty(String text) {
        return text.isEmpty() || NumberUtil.IsFloat(text);
    }

    public static boolean IsFloat(String text) {
        if (text == null) {
            return false;
        }
        try {
            float f = Float.parseFloat(text);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    @Nullable
    public static Float GetFloatValue(String text, @Nullable Float defaultValue) {
        if (NumberUtil.IsFloat(text)) {
            return Float.valueOf(Float.parseFloat(text));
        }
        return defaultValue;
    }

    public static boolean IsDoubleOrEmpty(String text) {
        return text.isEmpty() || NumberUtil.IsDouble(text);
    }

    public static boolean IsDouble(String text) {
        if (text == null) {
            return false;
        }
        try {
            double d = Double.parseDouble(text);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    @Nullable
    public static Double GetDoubleValue(String text, @Nullable Double defaultValue) {
        if (NumberUtil.IsDouble(text)) {
            return Double.parseDouble(text);
        }
        return defaultValue;
    }
}

