/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.config.conditions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.lightman314.lightmanscurrency.api.config.ConfigFile;
import io.github.lightman314.lightmanscurrency.api.config.options.ConfigOption;
import io.github.lightman314.lightmanscurrency.api.config.options.basic.BooleanOption;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.Map;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.common.conditions.ICondition;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ConfigCraftingCondition
implements ICondition {
    public static final MapCodec<ConfigCraftingCondition> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Codec.STRING.optionalFieldOf("fileName").forGetter(c -> Optional.empty()), (App)ResourceLocation.CODEC.optionalFieldOf("fileID").forGetter(c -> Optional.of(c.fileID)), (App)Codec.STRING.fieldOf("option").forGetter(c -> c.optionPath)).apply((Applicative)builder, ConfigCraftingCondition::load));
    private final ResourceLocation fileID;
    private final String optionPath;

    private ConfigCraftingCondition(ResourceLocation fileID, String optionPath) {
        this.fileID = fileID;
        this.optionPath = optionPath;
    }

    public static ConfigCraftingCondition of(ResourceLocation fileName, String optionPath) {
        return new ConfigCraftingCondition(fileName, optionPath);
    }

    public static ConfigCraftingCondition of(BooleanOption option) {
        Object path = null;
        ConfigFile file = option.getFile();
        if (file == null) {
            throw new IllegalArgumentException("Config Option was not attached to a config file!");
        }
        for (Map.Entry<String, ConfigOption<?>> entry : file.getAllOptions().entrySet()) {
            if (entry.getValue() != option) continue;
            return ConfigCraftingCondition.of(file.getFileID(), entry.getKey());
        }
        throw new IllegalArgumentException("Config Option was not a member of the config file!");
    }

    public boolean test(ICondition.IContext context) {
        Object obj;
        ConfigOption<?> option;
        ConfigFile file = ConfigFile.lookupFile(this.fileID);
        if (file != null && (option = file.getAllOptions().get(this.optionPath)) != null && (obj = option.get()) instanceof Boolean) {
            Boolean bool = (Boolean)obj;
            return bool;
        }
        return false;
    }

    public MapCodec<ConfigCraftingCondition> codec() {
        return CODEC;
    }

    private static ConfigCraftingCondition load(Optional<String> fileName, Optional<ResourceLocation> fileID, String option) {
        if (fileName.isPresent()) {
            ConfigFile file = ConfigFile.lookupFile(fileName.get());
            if (file != null) {
                return new ConfigCraftingCondition(file.getFileID(), option);
            }
            return new ConfigCraftingCondition(ConfigFile.forceGenerateID(fileName.get()), option);
        }
        if (fileID.isPresent()) {
            return new ConfigCraftingCondition(fileID.get(), option);
        }
        return new ConfigCraftingCondition(VersionUtil.modResource("unknown", "unknown"), option);
    }
}

