/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.easy_data.types;

import io.github.lightman314.lightmanscurrency.api.easy_data.EasyData;
import io.github.lightman314.lightmanscurrency.api.easy_data.EasyDataSettings;
import io.github.lightman314.lightmanscurrency.api.easy_data.ReadWriteContext;
import io.github.lightman314.lightmanscurrency.api.misc.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.api.notifications.Notification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.settings.ChangeSettingNotification;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class StringData
extends EasyData<String> {
    private String value;
    private final int maxLength;

    private StringData(EasyDataSettings<String> settings, String defaultValue, int maxLength) {
        super(settings);
        this.value = defaultValue;
        this.maxLength = maxLength;
    }

    public static EasyDataSettings.Builder<String, StringData> builder() {
        return StringData.builder("");
    }

    public static EasyDataSettings.Builder<String, StringData> builder(String defaultValue) {
        return StringData.builder("", -1);
    }

    public static EasyDataSettings.Builder<String, StringData> builder(String defaultValue, int maxLength) {
        return EasyDataSettings.builder((EasyDataSettings<T> b) -> new StringData((EasyDataSettings<String>)b, defaultValue, maxLength));
    }

    @Override
    protected void write(ReadWriteContext context, String tagKey) {
        context.tag.putString(tagKey, this.value);
    }

    @Override
    protected void read(ReadWriteContext context, String tagKey) {
        this.value = context.tag.getString(tagKey);
    }

    @Override
    public String get() {
        return this.value;
    }

    @Override
    protected void setInternal(String newValue) {
        this.value = this.maxLength > 0 && newValue.length() > this.maxLength ? newValue.substring(0, this.maxLength) : newValue;
    }

    @Override
    @Nullable
    protected Notification change(PlayerReference player, String newValue) {
        this.set(newValue);
        return ChangeSettingNotification.simple(player, this.settings.dataName, this.value);
    }
}

