/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.misc;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class BlockProtectionHelper {
    private static final List<BiPredicate<BlockState, BlockEntity>> PROTECTED_CHECKS = new ArrayList<BiPredicate<BlockState, BlockEntity>>();

    public static boolean ShouldProtect(@Nonnull BlockState state, @Nullable BlockEntity blockEntity) {
        return PROTECTED_CHECKS.stream().anyMatch(p -> p.test(state, blockEntity));
    }

    public static void ProtectBlockTag(@Nonnull TagKey<Block> tag) {
        BlockProtectionHelper.ProtectBlock((Block b) -> {
            for (Holder holder : BuiltInRegistries.BLOCK.getTagOrEmpty(tag)) {
                if (holder.value() != b) continue;
                return true;
            }
            return false;
        });
    }

    public static void ProtectBlock(@Nonnull Supplier<Block> block) {
        BlockProtectionHelper.ProtectBlock((Block b) -> b == block.get());
    }

    public static void ProtectBlock(@Nonnull Predicate<Block> predicate) {
        BlockProtectionHelper.Protect((s, e) -> predicate.test(s.getBlock()));
    }

    public static void ProtectBlockState(@Nonnull Predicate<BlockState> predicate) {
        BlockProtectionHelper.Protect((s, e) -> predicate.test((BlockState)s));
    }

    public static void ProtectBlockEntity(@Nonnull Supplier<BlockEntityType<?>> type) {
        BlockProtectionHelper.ProtectBlockEntity((BlockEntity e) -> e != null && e.getType() == type.get());
    }

    public static void ProtectBlockEntity(@Nonnull Predicate<BlockEntity> predicate) {
        BlockProtectionHelper.Protect((s, e) -> predicate.test((BlockEntity)e));
    }

    public static void Protect(@Nonnull BiPredicate<BlockState, BlockEntity> predicate) {
        if (predicate != null) {
            PROTECTED_CHECKS.add(Objects.requireNonNull(predicate));
        }
    }
}

