/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.misc.player;

import io.github.lightman314.lightmanscurrency.api.misc.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.api.ownership.Owner;
import io.github.lightman314.lightmanscurrency.api.ownership.builtin.FakeOwner;
import io.github.lightman314.lightmanscurrency.api.ownership.builtin.PlayerOwner;
import io.github.lightman314.lightmanscurrency.api.ownership.builtin.TeamOwner;
import io.github.lightman314.lightmanscurrency.common.player.LCAdminMode;
import io.github.lightman314.lightmanscurrency.common.util.IClientTracker;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;

public final class OwnerData
implements IClientTracker {
    private Owner backupOwner = Owner.getNull(this);
    private Owner currentOwner = Owner.getNull(this);
    private final IClientTracker parent;
    private final Consumer<OwnerData> onChanged;

    @Override
    public boolean isClient() {
        return this.parent.isClient();
    }

    public OwnerData(@Nonnull IClientTracker parent) {
        this(parent, (OwnerData o) -> {});
    }

    public OwnerData(@Nonnull IClientTracker parent, @Nonnull Runnable onChanged) {
        this(parent, (OwnerData o) -> onChanged.run());
    }

    public OwnerData(@Nonnull IClientTracker parent, @Nonnull Consumer<OwnerData> onChanged) {
        this.parent = parent;
        this.onChanged = onChanged;
    }

    @Nonnull
    public Owner getValidOwner() {
        return this.currentOwner.stillValid() ? this.currentOwner : this.backupOwner;
    }

    public boolean hasOwner() {
        return this.currentOwner.stillValid() || this.backupOwner.stillValid();
    }

    @Nonnull
    public CompoundTag save(@Nonnull HolderLookup.Provider lookup) {
        CompoundTag compound = new CompoundTag();
        compound.put("BackupOwner", (Tag)this.backupOwner.save(lookup));
        compound.put("Owner", (Tag)this.currentOwner.save(lookup));
        return compound;
    }

    public void load(@Nonnull CompoundTag compound, @Nonnull HolderLookup.Provider lookup) {
        if (compound.contains("BackupOwner") && compound.contains("Owner")) {
            this.backupOwner = Owner.load(compound.getCompound("BackupOwner"), lookup);
            this.currentOwner = Owner.load(compound.getCompound("Owner"), lookup);
        } else {
            this.backupOwner = FakeOwner.of("NULL");
            if (compound.contains("Custom")) {
                MutableComponent custom = Component.Serializer.fromJson((String)compound.getString("Custom"), (HolderLookup.Provider)lookup);
                this.backupOwner = FakeOwner.of(custom.copy());
                this.currentOwner = FakeOwner.of(custom);
            }
            if (compound.contains("Player")) {
                PlayerReference player = PlayerReference.load(compound.getCompound("Player"));
                this.backupOwner = PlayerOwner.of(player);
                this.currentOwner = PlayerOwner.of(player);
            }
            if (compound.contains("Team")) {
                this.currentOwner = TeamOwner.of(compound.getLong("Team"));
            }
        }
        if (this.backupOwner == null) {
            this.backupOwner = Owner.getNull();
        }
        this.backupOwner.setParent(this);
        if (this.currentOwner == null) {
            this.currentOwner = Owner.getNull();
        }
        this.currentOwner.setParent(this);
    }

    public void copyFrom(@Nonnull OwnerData owner) {
        this.backupOwner = owner.backupOwner.copy();
        this.backupOwner.setParent(this);
        this.currentOwner = owner.currentOwner.copy();
        this.currentOwner.setParent(this);
    }

    @Nonnull
    public PlayerReference getPlayerForContext() {
        return this.getValidOwner().asPlayerReference();
    }

    public boolean isAdmin(@Nonnull Player player) {
        return LCAdminMode.isAdminPlayer(player) || this.isAdmin(PlayerReference.of(player));
    }

    public boolean isAdmin(@Nonnull PlayerReference player) {
        return this.getValidOwner().isAdmin(player);
    }

    public boolean isMember(@Nonnull Player player) {
        return LCAdminMode.isAdminPlayer(player) || this.isMember(PlayerReference.of(player));
    }

    public boolean isMember(@Nonnull PlayerReference player) {
        return this.getValidOwner().isMember(player);
    }

    @Nonnull
    public MutableComponent getName() {
        return this.getValidOwner().getName();
    }

    public void SetOwner(@Nonnull Owner newOwner) {
        this.currentOwner = newOwner.copy();
        this.currentOwner.setParent(this);
        if (this.currentOwner.alwaysValid()) {
            this.backupOwner = this.currentOwner.copy();
            this.backupOwner.setParent(this);
        }
        this.onChanged.accept(this);
    }
}

