/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.ownership.builtin;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.misc.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.api.money.bank.reference.BankReference;
import io.github.lightman314.lightmanscurrency.api.money.bank.reference.builtin.TeamBankReference;
import io.github.lightman314.lightmanscurrency.api.notifications.Notification;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationAPI;
import io.github.lightman314.lightmanscurrency.api.ownership.Owner;
import io.github.lightman314.lightmanscurrency.api.ownership.OwnerType;
import io.github.lightman314.lightmanscurrency.api.stats.StatKey;
import io.github.lightman314.lightmanscurrency.api.teams.ITeam;
import io.github.lightman314.lightmanscurrency.api.teams.TeamAPI;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.ArrayList;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.MutableComponent;

public class TeamOwner
extends Owner {
    public static final OwnerType TYPE = OwnerType.create(VersionUtil.lcResource("team"), (tag, lookup) -> TeamOwner.of(tag.getLong("Team")));
    public final long teamID;

    @Nullable
    public final ITeam getTeam() {
        return TeamAPI.API.GetTeam(this, this.teamID);
    }

    private TeamOwner(long teamID) {
        this.teamID = teamID;
    }

    @Nonnull
    public static TeamOwner of(@Nonnull ITeam team) {
        return TeamOwner.of(team.getID());
    }

    @Nonnull
    public static TeamOwner of(long teamID) {
        return new TeamOwner(teamID);
    }

    @Override
    @Nonnull
    public MutableComponent getName() {
        ITeam team = this.getTeam();
        if (team != null) {
            return EasyText.literal(team.getName());
        }
        return EasyText.literal("NULL");
    }

    @Override
    @Nonnull
    public MutableComponent getCommandLabel() {
        return LCText.COMMAND_LCADMIN_DATA_OWNER_TEAM.get(this.getName(), this.teamID);
    }

    @Override
    public boolean stillValid() {
        return TeamAPI.API.GetTeam(this, this.teamID) != null;
    }

    @Override
    public boolean isOnline() {
        if (this.isClient()) {
            return false;
        }
        ITeam team = this.getTeam();
        if (team != null) {
            for (PlayerReference member : team.getAllMembers()) {
                if (member == null || !member.isOnline()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isAdmin(@Nonnull PlayerReference player) {
        ITeam team = this.getTeam();
        if (team != null) {
            return team.isAdmin(player);
        }
        return false;
    }

    @Override
    public boolean isMember(@Nonnull PlayerReference player) {
        ITeam team = this.getTeam();
        if (team != null) {
            return team.isMember(player);
        }
        return false;
    }

    @Override
    @Nonnull
    public PlayerReference asPlayerReference() {
        ITeam team = this.getTeam();
        if (team != null) {
            return team.getOwner().copyWithName(team.getName());
        }
        return PlayerReference.NULL;
    }

    @Override
    @Nullable
    public BankReference asBankReference() {
        ITeam team = this.getTeam();
        if (team != null && team.hasBankAccount()) {
            return TeamBankReference.of(team);
        }
        return null;
    }

    @Override
    public boolean hasNotificationLevels() {
        return true;
    }

    @Override
    public void pushNotification(@Nonnull Supplier<? extends Notification> notificationSource, int notificationLevel, boolean sendToChat) {
        ITeam team = this.getTeam();
        if (team == null) {
            return;
        }
        ArrayList<PlayerReference> sendTo = new ArrayList<PlayerReference>();
        if (notificationLevel < 1) {
            sendTo.addAll(team.getMembers());
        }
        if (notificationLevel < 2) {
            sendTo.addAll(team.getAdmins());
        }
        sendTo.add(team.getOwner());
        for (PlayerReference player : sendTo) {
            if (player == null || player.id == null) continue;
            NotificationAPI.API.PushPlayerNotification(player.id, notificationSource.get(), sendToChat);
        }
    }

    @Override
    public <T> void incrementStat(@Nonnull StatKey<?, T> key, @Nonnull T addValue) {
        ITeam team = this.getTeam();
        if (team != null) {
            team.getStats().incrementStat(key, addValue);
        }
    }

    @Override
    @Nonnull
    public OwnerType getType() {
        return TYPE;
    }

    @Override
    protected void saveAdditional(@Nonnull CompoundTag tag, @Nonnull HolderLookup.Provider lookup) {
        tag.putLong("Team", this.teamID);
    }

    @Override
    @Nonnull
    public Owner copy() {
        return new TeamOwner(this.teamID);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean matches(@Nonnull Owner other) {
        if (!(other instanceof TeamOwner)) return false;
        TeamOwner to = (TeamOwner)other;
        if (to.teamID != this.teamID) return false;
        return true;
    }
}

