/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.traders;

import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.TraderType;
import io.github.lightman314.lightmanscurrency.api.traders.rules.TradeRuleType;
import io.github.lightman314.lightmanscurrency.api.traders.terminal.ITradeSearchFilter;
import io.github.lightman314.lightmanscurrency.api.traders.terminal.ITraderSearchFilter;
import io.github.lightman314.lightmanscurrency.api.traders.trade.TradeData;
import io.github.lightman314.lightmanscurrency.common.impl.TraderAPIImpl;
import io.github.lightman314.lightmanscurrency.common.util.IClientTracker;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public abstract class TraderAPI {
    public static final TraderAPI API = TraderAPIImpl.INSTANCE;

    protected TraderAPI() {
    }

    @Deprecated(since="2.2.2.3")
    public static void registerTrader(@Nonnull TraderType<?> type) {
        API.RegisterTrader(type);
    }

    public abstract void RegisterTrader(@Nonnull TraderType<?> var1);

    @Deprecated
    @Nullable
    public static TraderType<?> getTraderType(@Nonnull ResourceLocation type) {
        return API.GetTraderType(type);
    }

    @Nullable
    public abstract TraderType<?> GetTraderType(@Nonnull ResourceLocation var1);

    @Deprecated
    public static void registerTradeRule(@Nonnull TradeRuleType<?> type) {
        API.RegisterTradeRule(type);
    }

    public abstract void RegisterTradeRule(@Nonnull TradeRuleType<?> var1);

    @Deprecated
    @Nullable
    public static TradeRuleType<?> getTradeRuleType(@Nonnull ResourceLocation type) {
        return API.GetTradeRuleType(type);
    }

    @Nullable
    public abstract TradeRuleType<?> GetTradeRuleType(@Nonnull ResourceLocation var1);

    @Deprecated
    @Nonnull
    public static List<TradeRuleType<?>> getTradeRuleTypes() {
        return API.GetAllTradeRuleTypes();
    }

    @Nonnull
    public abstract List<TradeRuleType<?>> GetAllTradeRuleTypes();

    @Deprecated
    public static void registerSearchFilter(@Nonnull ITraderSearchFilter filter) {
        API.RegisterTraderSearchFilter(filter);
    }

    public abstract void RegisterTraderSearchFilter(@Nonnull ITraderSearchFilter var1);

    @Deprecated
    public static boolean filterTrader(@Nonnull TraderData data, @Nonnull String searchText) {
        return API.FilterTrader(data, searchText);
    }

    public abstract boolean FilterTrader(@Nonnull TraderData var1, @Nonnull String var2);

    @Deprecated
    @Nonnull
    public static List<TraderData> filterTraders(@Nonnull List<TraderData> data, @Nonnull String searchText) {
        return API.FilterTraders(data, searchText);
    }

    @Nonnull
    public abstract List<TraderData> FilterTraders(@Nonnull List<TraderData> var1, @Nonnull String var2);

    public abstract void RegisterTradeSearchFilter(@Nonnull ITradeSearchFilter var1);

    public abstract boolean FilterTrade(@Nonnull TradeData var1, @Nonnull String var2, @Nonnull RegistryAccess var3);

    @Nonnull
    public abstract List<TradeData> FilterTrades(@Nonnull List<TradeData> var1, @Nonnull String var2, @Nonnull RegistryAccess var3);

    public abstract <T extends ITraderSearchFilter & ITradeSearchFilter> void RegisterSearchFilter(@Nonnull T var1);

    @Deprecated
    @Nullable
    public static TraderData getTrader(@Nonnull IClientTracker clientTracker, long traderID) {
        return API.GetTrader(clientTracker, traderID);
    }

    @Deprecated
    @Nullable
    public static TraderData getTrader(boolean isClient, long traderID) {
        return API.GetTrader(isClient, traderID);
    }

    @Nullable
    public final TraderData GetTrader(@Nonnull IClientTracker context, long traderID) {
        return this.GetTrader(context.isClient(), traderID);
    }

    @Nullable
    public abstract TraderData GetTrader(boolean var1, long var2);

    @Deprecated
    @Nonnull
    public static List<TraderData> getAllTraders(@Nonnull IClientTracker clientTracker) {
        return TraderAPI.getAllTraders(clientTracker.isClient());
    }

    @Deprecated
    @Nonnull
    public static List<TraderData> getAllTraders(boolean isClient) {
        return API.GetAllTraders(isClient);
    }

    @Nonnull
    public final List<TraderData> GetAllTraders(@Nonnull IClientTracker context) {
        return this.GetAllTraders(context.isClient());
    }

    @Nonnull
    public abstract List<TraderData> GetAllTraders(boolean var1);

    @Deprecated
    @Nonnull
    public static List<TraderData> getAllTerminalTraders(@Nonnull IClientTracker clientTracker) {
        return API.GetAllNetworkTraders(clientTracker);
    }

    @Deprecated
    @Nonnull
    public static List<TraderData> getAllTerminalTraders(boolean isClient) {
        return TraderAPI.getAllTraders(isClient).stream().filter(TraderData::showOnTerminal).collect(Collectors.toList());
    }

    public final List<TraderData> GetAllNetworkTraders(@Nonnull IClientTracker context) {
        return this.GetAllNetworkTraders(context.isClient());
    }

    public abstract List<TraderData> GetAllNetworkTraders(boolean var1);

    @Deprecated
    public static long addTrader(@Nonnull TraderData newTrader) {
        return API.CreateTrader(newTrader);
    }

    @Deprecated
    public static long addTrader(@Nonnull TraderData newTrader, @Nullable Player player) {
        return API.CreateTrader(newTrader, player);
    }

    public final long CreateTrader(@Nonnull TraderData newTrader) {
        return this.CreateTrader(newTrader, null);
    }

    public abstract long CreateTrader(@Nonnull TraderData var1, @Nullable Player var2);

    @Deprecated
    public static void deleteTrader(@Nonnull TraderData trader) {
        TraderAPI.deleteTrader(trader.getID());
    }

    @Deprecated
    public static void deleteTrader(long traderID) {
        API.DeleteTrader(traderID);
    }

    public final void DeleteTrader(@Nonnull TraderData trader) {
        this.DeleteTrader(trader.getID());
    }

    public abstract void DeleteTrader(long var1);
}

