/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.traders;

import com.google.gson.JsonObject;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;

public final class TraderType<T extends TraderData> {
    public final ResourceLocation type;
    private final Supplier<T> generator;

    public TraderType(@Nonnull ResourceLocation type, @Nonnull Supplier<T> generator) {
        this.type = type;
        this.generator = generator;
    }

    public T create() {
        return (T)((TraderData)this.generator.get());
    }

    public T load(boolean isClient, @Nonnull CompoundTag tag, @Nonnull HolderLookup.Provider lookup) {
        TraderData trader = (TraderData)this.generator.get();
        trader.load(tag, lookup);
        if (isClient) {
            trader.flagAsClient();
        }
        return (T)trader;
    }

    public T loadFromJson(@Nonnull JsonObject json, @Nonnull HolderLookup.Provider lookup) {
        TraderData trader = (TraderData)this.generator.get();
        trader.loadFromJson(json, lookup);
        return (T)trader;
    }

    public String toString() {
        return this.type.toString();
    }
}

