/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.traders.terminal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class PendingSearch {
    public static final PendingSearch EMPTY = new PendingSearch("", new HashMap<String, List<String>>(), new ArrayList<String>());
    public final String fullSearch;
    private final Map<String, List<String>> filteredInputs;
    private final Map<String, Result<List<String>>> filteredResults = new HashMap<String, Result<List<String>>>();
    private final List<String> unfilteredInputs;
    private final List<Result<String>> unfilteredResults = new ArrayList<Result<String>>();

    public boolean isBlank() {
        return this.fullSearch.isBlank();
    }

    private PendingSearch(String fullSearch, Map<String, List<String>> filteredInputs, List<String> unfilteredInputs) {
        this.fullSearch = fullSearch;
        this.filteredInputs = filteredInputs;
        this.unfilteredInputs = unfilteredInputs;
        filteredInputs.forEach((filter, list) -> this.filteredResults.put((String)filter, (Result<List<String>>)new Result<List>((List)list)));
        unfilteredInputs.forEach(s -> this.unfilteredResults.add(new Result<String>((String)s)));
    }

    public PendingSearch copy() {
        return new PendingSearch(this.fullSearch, this.filteredInputs, this.unfilteredInputs);
    }

    public static PendingSearch of(String searchText) {
        if (searchText.isBlank()) {
            return EMPTY;
        }
        searchText = searchText.toLowerCase();
        HashMap<String, List<String>> filteredInputs = new HashMap<String, List<String>>();
        ArrayList<String> unfilteredInputs = new ArrayList<String>();
        for (String input : PendingSearch.splitRawString(searchText)) {
            if (input.contains(":")) {
                String[] split = input.split(":", 2);
                List list = filteredInputs.getOrDefault(split[0], new ArrayList());
                list.add(split[1]);
                filteredInputs.put(split[0], list);
                continue;
            }
            unfilteredInputs.add(input);
        }
        return new PendingSearch(searchText, filteredInputs, unfilteredInputs);
    }

    private static List<String> splitRawString(String rawString) {
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder temp = new StringBuilder();
        boolean inQuote = false;
        for (int i = 0; i < rawString.length(); ++i) {
            char c = rawString.charAt(i);
            if (c == '\"') {
                inQuote = !inQuote;
                continue;
            }
            if (inQuote && c == '\\') {
                temp.append(rawString.charAt(++i));
                continue;
            }
            if (c == ' ' && !inQuote) {
                list.add(temp.toString());
                temp = new StringBuilder();
                continue;
            }
            temp.append(c);
        }
        if (!temp.isEmpty()) {
            list.add(temp.toString());
        }
        return list;
    }

    public void processFilter(String filter, Predicate<String> processor) {
        this.processStrictFilter(filter, processor);
        this.processUnfiltered(processor);
    }

    public void processStrictFilter(String filter, Predicate<String> processor) {
        if (this.filteredResults.containsKey(filter)) {
            Result<List<String>> result = this.filteredResults.get(filter);
            boolean pass = true;
            for (String string : (List)result.value) {
                if (string.startsWith("!")) {
                    pass = pass && !processor.test(string.substring(1));
                    continue;
                }
                pass = pass && processor.test(string);
            }
            result.setPassed(pass);
        }
    }

    public void processUnfiltered(Predicate<String> processor) {
        for (Result<String> result : this.unfilteredResults) {
            if (((String)result.value).startsWith("!")) {
                result.setPassed(!processor.test(((String)result.value).substring(1)));
                continue;
            }
            result.setPassed(processor.test((String)result.value));
        }
    }

    public boolean hasPassed() {
        return this.filteredResults.values().stream().allMatch(v -> v.passed) && this.unfilteredResults.stream().allMatch(v -> v.passed);
    }

    private static class Result<T> {
        final T value;
        boolean passed = false;

        Result(T value) {
            this.value = value;
        }

        void setPassed(boolean passed) {
            this.passed = this.passed || passed;
        }
    }
}

