/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.widget;

import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.money.bank.BankAPI;
import io.github.lightman314.lightmanscurrency.api.money.bank.reference.BankReference;
import io.github.lightman314.lightmanscurrency.client.gui.widget.ScrollListener;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.BankAccountSelectButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyAddonHelper;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyWidgetWithChildren;
import io.github.lightman314.lightmanscurrency.client.gui.widget.scroll.IScrollable;
import io.github.lightman314.lightmanscurrency.client.gui.widget.scroll.ScrollBarWidget;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.FieldsAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;

public class BankAccountSelectionWidget
extends EasyWidgetWithChildren
implements IScrollable,
Comparator<BankReference> {
    private final int rows;
    private final Predicate<BankReference> filter;
    private final Supplier<BankReference> selectedAccount;
    private final Consumer<BankReference> consumer;
    private int scroll = 0;

    private BankAccountSelectionWidget(@Nonnull Builder builder) {
        super(builder);
        this.rows = builder.rows;
        this.filter = builder.filter;
        this.selectedAccount = builder.selectedAccount;
        this.consumer = builder.handler;
    }

    @Override
    public void addChildren(@Nonnull ScreenArea area) {
        this.addChild(((ScrollBarWidget.Builder)ScrollBarWidget.builder().onRight(this).addon(EasyAddonHelper.visibleCheck(this::isVisible))).build());
        this.addChild(((ScrollListener.Builder)ScrollListener.builder().area(area)).listener(this).build());
        for (int i = 0; i < this.rows; ++i) {
            int index = i;
            this.addChild(((BankAccountSelectButton.Builder)((BankAccountSelectButton.Builder)BankAccountSelectButton.builder().position(area.pos.offset(0, i * 20))).width(this.width).pressAction(() -> this.selectAccount(index))).currentlySelected(this.selectedAccount).account(() -> this.getAccount(index)).visible(this::isVisible).build());
        }
    }

    private List<BankReference> getBankAccounts() {
        ArrayList<BankReference> list = new ArrayList<BankReference>(BankAPI.API.GetAllBankReferences(true).stream().filter(this.filter).toList());
        list.sort(this);
        return list;
    }

    @Nullable
    private BankReference getAccount(int index) {
        List<BankReference> accounts = this.getBankAccounts();
        int i = index + this.scroll;
        if (i >= 0 && i < accounts.size()) {
            return accounts.get(i);
        }
        return null;
    }

    private void selectAccount(int index) {
        BankReference account = this.getAccount(index);
        if (account != null) {
            this.consumer.accept(account);
        }
    }

    @Override
    protected void renderWidget(@Nonnull EasyGuiGraphics gui) {
        gui.fill(this.getArea().atPosition(ScreenPosition.ZERO), -16777216);
    }

    @Override
    public int currentScroll() {
        return this.scroll;
    }

    @Override
    public void setScroll(int newScroll) {
        this.scroll = newScroll;
    }

    @Override
    public int getMaxScroll() {
        return IScrollable.calculateMaxScroll(this.rows, this.getBankAccounts().size());
    }

    @Override
    public int compare(BankReference rA, BankReference rB) {
        boolean matchA = this.isCurrentAccount(rA);
        boolean matchB = this.isCurrentAccount(rB);
        if (matchA && !matchB) {
            return -1;
        }
        if (matchB && !matchA) {
            return 1;
        }
        if (rA != null && rB == null) {
            return -1;
        }
        if (rB != null && rA == null) {
            return 1;
        }
        if (rA == null && rB == null) {
            return 0;
        }
        return Integer.compare(rB.sortPriority(), rA.sortPriority());
    }

    private boolean isCurrentAccount(@Nullable BankReference reference) {
        return reference != null && reference.equals(this.selectedAccount.get());
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    @MethodsReturnNonnullByDefault
    @FieldsAreNonnullByDefault
    public static class Builder
    extends EasyWidget.EasyBuilder<Builder> {
        int rows = 1;
        Predicate<BankReference> filter = r -> true;
        Supplier<BankReference> selectedAccount = () -> null;
        Consumer<BankReference> handler = r -> {};

        private Builder() {
            super(100, 20);
        }

        @Override
        protected Builder getSelf() {
            return this;
        }

        public Builder width(int width) {
            this.changeWidth(width);
            return this;
        }

        public Builder rows(int rows) {
            this.rows = rows;
            this.changeHeight(rows * 20);
            return this;
        }

        public Builder filter(Predicate<BankReference> filter) {
            this.filter = filter;
            return this;
        }

        public Builder selected(Supplier<BankReference> selectedAccount) {
            this.selectedAccount = selectedAccount;
            return this;
        }

        public Builder handler(Consumer<BankReference> handler) {
            this.handler = handler;
            return this;
        }

        public BankAccountSelectionWidget build() {
            return new BankAccountSelectionWidget(this);
        }
    }
}

