/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.blockentity;

import io.github.lightman314.lightmanscurrency.api.misc.blocks.ICapabilityBlock;
import io.github.lightman314.lightmanscurrency.common.blockentity.variant.IVariantSupportingBlockEntity;
import io.github.lightman314.lightmanscurrency.common.blocks.variant.IVariantBlock;
import io.github.lightman314.lightmanscurrency.common.core.ModBlockEntities;
import io.github.lightman314.lightmanscurrency.common.core.util.BlockEntityBlockHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;

public class CapabilityInterfaceBlockEntity
extends BlockEntity
implements IVariantSupportingBlockEntity {
    public CapabilityInterfaceBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntities.CAPABILITY_INTERFACE.get(), pos, state);
    }

    public static <T, C> void easyRegisterCapProvider(@Nonnull RegisterCapabilitiesEvent event, @Nonnull BlockCapability<T, C> capability) {
        event.registerBlock(capability, (level, pos, state, be, context) -> {
            Block patt0$temp = state.getBlock();
            if (patt0$temp instanceof ICapabilityBlock) {
                ICapabilityBlock handlerBlock = (ICapabilityBlock)patt0$temp;
                BlockPos newPos = handlerBlock.getCapabilityBlockPos(state, (LevelAccessor)level, pos);
                if (newPos.equals((Object)pos) || level.getBlockEntity(newPos) instanceof CapabilityInterfaceBlockEntity) {
                    return null;
                }
                return level.getCapability(capability, newPos, context);
            }
            return null;
        }, BlockEntityBlockHelper.getBlocksForBlockEntities(BlockEntityBlockHelper.CAPABILITY_INTERFACE_TYPE));
    }

    @Override
    @Nullable
    public ResourceLocation getCurrentVariant() {
        BlockState state = this.getBlockState();
        Block block = state.getBlock();
        if (block instanceof ICapabilityBlock) {
            ICapabilityBlock block2 = (ICapabilityBlock)block;
            BlockPos newPos = block2.getCapabilityBlockPos(state, (LevelAccessor)this.level, this.worldPosition);
            BlockEntity be = this.level.getBlockEntity(newPos);
            if (be instanceof CapabilityInterfaceBlockEntity) {
                return null;
            }
            if (be instanceof IVariantSupportingBlockEntity) {
                IVariantSupportingBlockEntity vsbe = (IVariantSupportingBlockEntity)be;
                return vsbe.getCurrentVariant();
            }
        }
        return null;
    }

    @Override
    public void setVariant(@Nullable ResourceLocation variant) {
        BlockState state = this.getBlockState();
        Block block = state.getBlock();
        if (block instanceof ICapabilityBlock) {
            ICapabilityBlock block2 = (ICapabilityBlock)block;
            BlockPos newPos = block2.getCapabilityBlockPos(state, (LevelAccessor)this.level, this.worldPosition);
            BlockEntity be = this.level.getBlockEntity(newPos);
            if (be instanceof CapabilityInterfaceBlockEntity) {
                return;
            }
            if (be instanceof IVariantSupportingBlockEntity) {
                IVariantSupportingBlockEntity vsbe = (IVariantSupportingBlockEntity)be;
                vsbe.setVariant(variant);
            }
        }
    }

    public void onLoad() {
        BlockState state;
        Block block;
        if (this.getCurrentVariant() != null && (block = (state = this.getBlockState()).getBlock()) instanceof IVariantBlock) {
            IVariantBlock vb = (IVariantBlock)block;
            if (!((Boolean)state.getValue((Property)IVariantBlock.VARIANT)).booleanValue()) {
                this.level.setBlockAndUpdate(this.worldPosition, (BlockState)state.setValue((Property)IVariantBlock.VARIANT, (Comparable)Boolean.valueOf(true)));
            }
        }
        super.onLoad();
    }
}

