/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.blockentity.trader;

import io.github.lightman314.lightmanscurrency.api.misc.blocks.IRotatableBlock;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.blockentity.trader.ItemTraderBlockEntity;
import io.github.lightman314.lightmanscurrency.common.core.ModBlockEntities;
import io.github.lightman314.lightmanscurrency.common.traders.item.ItemTraderData;
import io.github.lightman314.lightmanscurrency.common.traders.item.ItemTraderDataArmor;
import io.github.lightman314.lightmanscurrency.common.traders.item.tradedata.ItemTradeData;
import io.github.lightman314.lightmanscurrency.common.traders.item.tradedata.restrictions.EquipmentRestriction;
import io.github.lightman314.lightmanscurrency.common.traders.item.tradedata.restrictions.ItemTradeRestriction;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class ArmorDisplayTraderBlockEntity
extends ItemTraderBlockEntity {
    public static final int TRADE_COUNT = 4;
    private static final int TICK_DELAY = 20;
    UUID armorStandID = null;
    int updateTimer = 0;
    private boolean loaded = false;

    public void flagAsLoaded() {
        this.loaded = true;
    }

    public ArmorDisplayTraderBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntities.ARMOR_TRADER.get(), pos, state, 4);
    }

    @Override
    @Nonnull
    public ItemTraderData buildNewTrader() {
        return new ItemTraderDataArmor(this.level, this.worldPosition);
    }

    @Override
    public void serverTick() {
        super.serverTick();
        if (!this.loaded) {
            return;
        }
        if (this.updateTimer <= 0) {
            this.updateTimer = 20;
            this.validateArmorStand();
            this.validateArmorStandValues();
            this.updateArmorStandArmor();
            this.killIntrudingArmorStands();
        } else {
            --this.updateTimer;
        }
    }

    public void validateArmorStand() {
        if (this.isClient()) {
            return;
        }
        ArmorStand armorStand = this.getArmorStand();
        if (armorStand == null || armorStand.isRemoved()) {
            this.spawnArmorStand();
        }
    }

    private void spawnArmorStand() {
        if (this.level == null || this.isClient()) {
            return;
        }
        ArmorStand armorStand = new ArmorStand(this.level, (double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY(), (double)this.worldPosition.getZ() + 0.5);
        armorStand.moveTo((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY(), (double)this.worldPosition.getZ() + 0.5, this.getStandRotation(), 0.0f);
        armorStand.setInvulnerable(true);
        armorStand.setNoGravity(true);
        armorStand.setSilent(true);
        CompoundTag compound = armorStand.saveWithoutId(new CompoundTag());
        compound.putBoolean("Marker", true);
        compound.putBoolean("NoBasePlate", true);
        armorStand.load(compound);
        this.level.addFreshEntity((Entity)armorStand);
        this.armorStandID = armorStand.getUUID();
        this.setChanged();
    }

    protected void updateArmorStandArmor() {
        TraderData data;
        ArmorStand armorStand = this.getArmorStand();
        if (armorStand != null && (data = this.getRawTraderData()) instanceof ItemTraderData) {
            ItemTraderData trader = (ItemTraderData)data;
            List<ItemTradeData> trades = trader.getTradeData();
            for (int i = 0; i < 4 && i < trades.size(); ++i) {
                ItemTradeData thisTrade = trades.get(i);
                ItemTradeRestriction r = thisTrade.getRestriction();
                EquipmentSlot slot = null;
                if (r instanceof EquipmentRestriction) {
                    EquipmentRestriction er = (EquipmentRestriction)r;
                    slot = er.getEquipmentSlot();
                }
                if (slot == null) continue;
                if (thisTrade.hasStock(trader) || trader.isCreative()) {
                    ItemStack item = thisTrade.getSellItem(0);
                    if (item.isEmpty()) {
                        item = thisTrade.getSellItem(1);
                    }
                    armorStand.setItemSlot(slot, item);
                    continue;
                }
                armorStand.setItemSlot(slot, ItemStack.EMPTY);
            }
        }
    }

    public void killIntrudingArmorStands() {
        ArmorStand armorStand = this.getArmorStand();
        if (this.level != null && armorStand != null) {
            this.level.getEntitiesOfClass(ArmorStand.class, this.getBlockState().getShape((BlockGetter)this.level, this.worldPosition).bounds()).forEach(as -> {
                if (as.position().equals((Object)armorStand.position())) {
                    as.remove(Entity.RemovalReason.DISCARDED);
                }
            });
        }
    }

    protected void validateArmorStandValues() {
        ArmorStand armorStand = this.getArmorStand();
        if (armorStand == null) {
            return;
        }
        armorStand.moveTo((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY(), (double)((float)this.worldPosition.getZ() + 0.5f), this.getStandRotation(), 0.0f);
        if (!armorStand.isInvulnerable()) {
            armorStand.setInvulnerable(true);
        }
        if (armorStand.isInvisible()) {
            armorStand.setInvisible(false);
        }
        if (!armorStand.noPhysics) {
            armorStand.setNoGravity(true);
        }
        if (!armorStand.isSilent()) {
            armorStand.setSilent(true);
        }
        if (!armorStand.isNoBasePlate() || armorStand.isMarker()) {
            CompoundTag compound = armorStand.saveWithoutId(new CompoundTag());
            if (!armorStand.isNoBasePlate()) {
                compound.putBoolean("NoBasePlate", true);
            }
            if (armorStand.isMarker()) {
                compound.remove("Marker");
            }
            armorStand.load(compound);
        }
    }

    @Override
    public void saveAdditional(@Nonnull CompoundTag compound, @Nonnull HolderLookup.Provider lookup) {
        this.writeArmorStandData(compound);
        super.saveAdditional(compound, lookup);
    }

    protected void writeArmorStandData(CompoundTag compound) {
        if (this.armorStandID != null) {
            compound.putUUID("ArmorStand", this.armorStandID);
        }
    }

    @Override
    public void loadAdditional(@Nonnull CompoundTag compound, @Nonnull HolderLookup.Provider lookup) {
        this.loaded = true;
        if (compound.contains("ArmorStand")) {
            this.armorStandID = compound.getUUID("ArmorStand");
        }
        super.loadAdditional(compound, lookup);
    }

    protected ArmorStand getArmorStand() {
        ServerLevel sl;
        Entity entity;
        Level level = this.level;
        if (level instanceof ServerLevel && (entity = (sl = (ServerLevel)level).getEntity(this.armorStandID)) instanceof ArmorStand) {
            ArmorStand armorStand = (ArmorStand)entity;
            return armorStand;
        }
        return null;
    }

    public void destroyArmorStand() {
        ArmorStand armorStand = this.getArmorStand();
        if (armorStand != null) {
            armorStand.kill();
        }
    }

    protected float getStandRotation() {
        Direction facing = Direction.NORTH;
        if (this.getBlockState().getBlock() instanceof IRotatableBlock) {
            facing = ((IRotatableBlock)this.getBlockState().getBlock()).getFacing(this.getBlockState());
        }
        if (facing == Direction.SOUTH) {
            return 180.0f;
        }
        if (facing == Direction.NORTH) {
            return 0.0f;
        }
        if (facing == Direction.WEST) {
            return -90.0f;
        }
        if (facing == Direction.EAST) {
            return 90.0f;
        }
        return 0.0f;
    }
}

