/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.core;

import com.mojang.serialization.Codec;
import io.github.lightman314.lightmanscurrency.api.codecs.LCCodecs;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.upgrades.UpgradeData;
import io.github.lightman314.lightmanscurrency.common.core.ModRegistries;
import io.github.lightman314.lightmanscurrency.common.data.types.LootTableEntry;
import io.github.lightman314.lightmanscurrency.common.items.ancient_coins.AncientCoinType;
import io.github.lightman314.lightmanscurrency.common.items.data.ATMCardData;
import io.github.lightman314.lightmanscurrency.common.items.data.ItemStackData;
import io.github.lightman314.lightmanscurrency.common.items.data.MoneyBagData;
import io.github.lightman314.lightmanscurrency.common.items.data.SoundEntry;
import io.github.lightman314.lightmanscurrency.common.items.data.TicketData;
import io.github.lightman314.lightmanscurrency.common.items.data.TraderItemData;
import io.github.lightman314.lightmanscurrency.common.items.data.WalletData;
import io.github.lightman314.lightmanscurrency.common.upgrades.types.coin_chest.data.BankUpgradeData;
import io.github.lightman314.lightmanscurrency.common.upgrades.types.coin_chest.data.ExchangeUpgradeData;
import io.github.lightman314.lightmanscurrency.common.upgrades.types.coin_chest.data.SecurityUpgradeData;
import java.util.List;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Unit;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.ItemStack;

public class ModDataComponents {
    public static final Supplier<DataComponentType<WalletData>> WALLET_DATA = ModDataComponents.register("wallet_data", builder -> builder.persistent(WalletData.CODEC).networkSynchronized(WalletData.STREAM_CODEC));
    public static final Supplier<DataComponentType<List<BlockPos>>> CASH_REGISTER_TRADER_POSITIONS = ModDataComponents.register("cash_register_trader_positions", builder -> builder.persistent(BlockPos.CODEC.listOf()));
    public static final Supplier<DataComponentType<List<ItemStack>>> COIN_JAR_CONTENTS = ModDataComponents.register("coin_jar_contents", builder -> builder.persistent(ItemStack.OPTIONAL_CODEC.listOf()).cacheEncoding());
    public static final Supplier<DataComponentType<TicketData>> TICKET_DATA = ModDataComponents.register("ticket_data", builder -> builder.persistent(TicketData.CODEC).networkSynchronized(TicketData.STREAM_CODEC).cacheEncoding());
    public static final Supplier<DataComponentType<TraderItemData>> TRADER_ITEM_DATA = ModDataComponents.register("trader_data", builder -> builder.persistent(TraderItemData.CODEC).networkSynchronized(TraderItemData.STREAM_CODEC).cacheEncoding());
    public static final Supplier<DataComponentType<UpgradeData>> UPGRADE_DATA = ModDataComponents.register("upgrade_data", builder -> builder.persistent(UpgradeData.CODEC).networkSynchronized(UpgradeData.STREAM_CODEC));
    public static final Supplier<DataComponentType<ExchangeUpgradeData>> EXCHANGE_UPGRADE_DATA = ModDataComponents.register("exchange_upgrade_data", builder -> builder.persistent(ExchangeUpgradeData.CODEC).networkSynchronized(ExchangeUpgradeData.STREAM_CODEC));
    public static final Supplier<DataComponentType<SecurityUpgradeData>> SECURITY_UPGRADE_DATA = ModDataComponents.register("security_upgrade_data", builder -> builder.persistent(SecurityUpgradeData.CODEC).networkSynchronized(SecurityUpgradeData.STREAM_CODEC));
    public static final Supplier<DataComponentType<BankUpgradeData>> BANK_UPGRADE_DATA = ModDataComponents.register("bank_upgrade_data", builder -> builder.persistent(BankUpgradeData.CODEC).networkSynchronized(BankUpgradeData.STREAM_CODEC));
    public static final Supplier<DataComponentType<Boolean>> UPGRADE_ACTIVE = ModDataComponents.registerBool("upgrade_active");
    public static final Supplier<DataComponentType<ATMCardData>> ATM_CARD_DATA = ModDataComponents.register("atm_card_data", builder -> builder.persistent(ATMCardData.CODEC).networkSynchronized(ATMCardData.STREAM_CODEC));
    public static final Supplier<DataComponentType<MoneyValue>> MONEY_VALUE = ModDataComponents.register("money_value", builder -> builder.persistent(LCCodecs.MONEY_VALUE).networkSynchronized(LCCodecs.MONEY_VALUE_STREAM));
    public static final Supplier<DataComponentType<ItemStackData>> GACHA_ITEM = ModDataComponents.register("gacha_item", builder -> builder.persistent(ItemStackData.CODEC).networkSynchronized(ItemStackData.STREAM_CODEC));
    public static final Supplier<DataComponentType<MoneyBagData>> MONEY_BAG_CONTENTS = ModDataComponents.register("money_bag_data", builder -> builder.persistent(MoneyBagData.CODEC).networkSynchronized(MoneyBagData.STREAM_CODEC));
    public static final Supplier<DataComponentType<LootTableEntry>> LOOT_TABLE_ENTRY = ModDataComponents.register("loot_table", builder -> builder.persistent(LootTableEntry.CODEC).networkSynchronized(LootTableEntry.STREAM_CODEC));
    public static final Supplier<DataComponentType<ResourceLocation>> MODEL_VARIANT = ModDataComponents.registerResource("model_variant");
    public static final Supplier<DataComponentType<Integer>> WALLET_LEVEL = ModDataComponents.registerInt("wallet_level");
    public static final Supplier<DataComponentType<Integer>> WALLET_CAPACITY = ModDataComponents.registerInt("wallet_capacity");
    public static final Supplier<DataComponentType<Boolean>> WALLET_INVULNERABLE = ModDataComponents.registerBool("wallet_invulnerable");
    public static final Supplier<DataComponentType<Integer>> WALLET_BONUS_MAGNET = ModDataComponents.registerInt("wallet_bonus_magnet");
    public static final Supplier<DataComponentType<Integer>> WALLET_UPGRADE_LIMIT = ModDataComponents.registerInt("wallet_upgrade_limit");
    public static final Supplier<DataComponentType<ResourceLocation>> WALLET_MODEL = ModDataComponents.registerResource("wallet_model");
    public static final Supplier<DataComponentType<List<SoundEntry>>> WALLET_COIN_SOUND = ModDataComponents.register("wallet_coin_sound", builder -> builder.persistent(SoundEntry.CODEC.listOf()));
    public static final Supplier<DataComponentType<List<MobEffectInstance>>> CHOCOLATE_EFFECTS = ModDataComponents.register("chocolate_effects", builder -> builder.persistent(MobEffectInstance.CODEC.listOf()));
    public static final Supplier<DataComponentType<Float>> CHOCOLATE_HEALING = ModDataComponents.registerFloat("chocolate_healing");
    public static final Supplier<DataComponentType<AncientCoinType>> ANCIENT_COIN_TYPE = ModDataComponents.register("ancient_coin_type", builder -> builder.persistent(AncientCoinType.CODEC));
    public static final Supplier<DataComponentType<Unit>> ANCIENT_COIN_RANDOM = ModDataComponents.register("ancient_coin_random", builder -> builder.persistent(Unit.CODEC).networkSynchronized(StreamCodec.unit((Object)Unit.INSTANCE)));

    public static void init() {
    }

    private static <T> Supplier<DataComponentType<T>> register(@Nonnull String name, @Nonnull UnaryOperator<DataComponentType.Builder<T>> builder) {
        return ModRegistries.DATA_COMPONENTS.register(name, () -> ((DataComponentType.Builder)builder.apply(DataComponentType.builder())).build());
    }

    private static Supplier<DataComponentType<Boolean>> registerBool(@Nonnull String name) {
        return ModDataComponents.register(name, builder -> builder.persistent((Codec)Codec.BOOL).networkSynchronized(StreamCodec.of(FriendlyByteBuf::writeBoolean, FriendlyByteBuf::readBoolean)));
    }

    private static Supplier<DataComponentType<Integer>> registerInt(@Nonnull String name) {
        return ModDataComponents.register(name, builder -> builder.persistent((Codec)Codec.INT).networkSynchronized(StreamCodec.of(FriendlyByteBuf::writeInt, FriendlyByteBuf::readInt)));
    }

    private static Supplier<DataComponentType<Float>> registerFloat(@Nonnull String name) {
        return ModDataComponents.register(name, builder -> builder.persistent((Codec)Codec.FLOAT).networkSynchronized(StreamCodec.of(FriendlyByteBuf::writeFloat, FriendlyByteBuf::readFloat)));
    }

    private static Supplier<DataComponentType<ResourceLocation>> registerResource(@Nonnull String name) {
        return ModDataComponents.register(name, builder -> builder.persistent(ResourceLocation.CODEC).networkSynchronized(ResourceLocation.STREAM_CODEC));
    }
}

