/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.data.types;

import io.github.lightman314.lightmanscurrency.api.events.NotificationEvent;
import io.github.lightman314.lightmanscurrency.api.misc.data.CustomData;
import io.github.lightman314.lightmanscurrency.api.misc.data.CustomDataType;
import io.github.lightman314.lightmanscurrency.api.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.api.notifications.Notification;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationData;
import io.github.lightman314.lightmanscurrency.common.util.LookupHelper;
import io.github.lightman314.lightmanscurrency.network.message.notifications.SPacketChatNotification;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.FieldsAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

@MethodsReturnNonnullByDefault
@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
public class NotificationDataCache
extends CustomData {
    public static final CustomDataType<NotificationDataCache> TYPE = new CustomDataType<NotificationDataCache>("lightmanscurrency_notification_data", NotificationDataCache::new);
    private final Map<UUID, NotificationData> playerNotifications = new HashMap<UUID, NotificationData>();

    private NotificationDataCache() {
    }

    @Override
    public CustomDataType<?> getType() {
        return TYPE;
    }

    @Override
    public void save(CompoundTag tag, HolderLookup.Provider lookup) {
        ListTag notificationData = new ListTag();
        this.playerNotifications.forEach((id, data) -> {
            CompoundTag entry = data.save(lookup);
            entry.putUUID("Player", id);
            notificationData.add((Object)entry);
        });
        tag.put("PlayerNotifications", (Tag)notificationData);
    }

    @Override
    protected void load(CompoundTag tag, HolderLookup.Provider lookup) {
        ListTag notificationData = tag.getList("PlayerNotifications", 10);
        for (int i = 0; i < notificationData.size(); ++i) {
            CompoundTag entry = notificationData.getCompound(i);
            UUID id = entry.getUUID("Player");
            NotificationData data = NotificationData.loadFrom(entry, lookup);
            if (id == null || data == null) continue;
            this.playerNotifications.put(id, data);
        }
    }

    public NotificationData getNotifications(Player player) {
        return this.getNotifications(player.getUUID());
    }

    public NotificationData getNotifications(UUID player) {
        if (!this.playerNotifications.containsKey(player)) {
            this.playerNotifications.put(player, new NotificationData());
            this.setChanged();
        }
        return this.playerNotifications.get(player);
    }

    public void markNotificationsDirty(UUID player) {
        this.setChanged();
        if (this.isServer() && this.playerNotifications.containsKey(player)) {
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            if (server == null) {
                return;
            }
            ServerPlayer sp = server.getPlayerList().getPlayer(player);
            if (sp == null) {
                return;
            }
            this.syncNotifications(sp);
        }
    }

    public void pushNotification(UUID player, Notification notification) {
        this.pushNotification(player, notification, true);
    }

    public void pushNotification(UUID player, Notification notification, boolean pushToChat) {
        ServerPlayer sp;
        MinecraftServer server;
        NotificationData data = this.getNotifications(player);
        NotificationEvent.NotificationSent.Pre event = new NotificationEvent.NotificationSent.Pre(player, data, notification);
        if (((NotificationEvent.NotificationSent.Pre)NeoForge.EVENT_BUS.post((Event)event)).isCanceled()) {
            return;
        }
        data.addNotification(event.getNotification());
        this.markNotificationsDirty(player);
        NeoForge.EVENT_BUS.post((Event)new NotificationEvent.NotificationSent.Post(player, data, event.getNotification()));
        if (pushToChat && (server = ServerLifecycleHooks.getCurrentServer()) != null && (sp = server.getPlayerList().getPlayer(player)) != null) {
            new SPacketChatNotification(notification).sendTo(sp);
        }
    }

    private void syncNotifications(ServerPlayer player) {
        this.sendSyncPacket(this.builder().setCompound("UpdateNotifications", this.getNotifications((Player)player).save((HolderLookup.Provider)LookupHelper.getRegistryAccess())).setUUID("Player", player.getUUID()), player);
    }

    @Override
    protected void parseSyncPacket(LazyPacketData message, HolderLookup.Provider lookup) {
        if (message.contains("UpdateNotifications")) {
            NotificationData data = NotificationData.loadFrom(message.getNBT("UpdateNotifications"), lookup).flagAsClient(this);
            UUID player = message.getUUID("Player");
            this.playerNotifications.put(player, data);
        }
    }

    @Override
    public void onPlayerJoin(ServerPlayer player) {
        this.syncNotifications(player);
    }
}

