/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.emergency_ejection;

import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.ejection.EjectionData;
import io.github.lightman314.lightmanscurrency.api.ejection.EjectionDataType;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.misc.player.OwnerData;
import io.github.lightman314.lightmanscurrency.api.traders.TraderAPI;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.TraderState;
import io.github.lightman314.lightmanscurrency.common.core.ModDataComponents;
import io.github.lightman314.lightmanscurrency.common.menus.containers.NonEmptyContainer;
import io.github.lightman314.lightmanscurrency.common.util.IClientTracker;
import io.github.lightman314.lightmanscurrency.common.util.IconData;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;

public class TraderEjectionData
extends EjectionData {
    public static final EjectionDataType TYPE = new Type();
    private IData data;

    public TraderEjectionData(long traderID, @Nonnull ItemStack item) {
        this.data = new PreSplitData(traderID, item);
    }

    private TraderEjectionData(@Nonnull IData data) {
        this.data = data;
    }

    @Override
    @Nonnull
    public OwnerData getOwner() {
        return this.data.getOwner(this);
    }

    @Override
    @Nonnull
    public Component getName() {
        return this.data.getName(this);
    }

    @Override
    @Nonnull
    public EjectionDataType getType() {
        return TYPE;
    }

    @Override
    @Nonnull
    public Container getContents() {
        return this.data.getContents();
    }

    @Override
    protected void saveAdditional(@Nonnull CompoundTag tag, @Nonnull HolderLookup.Provider lookup) {
        tag.putBoolean("Split", this.data.isSplit());
        this.data.saveAdditional(tag, lookup);
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty(this) || super.isEmpty();
    }

    @Override
    public boolean canSplit() {
        return this.data.isPreSplit();
    }

    public long getTraderID() {
        IData iData = this.data;
        if (iData instanceof PreSplitData) {
            PreSplitData d = (PreSplitData)iData;
            return d.traderID;
        }
        return -1L;
    }

    public void delete() {
        this.data = EmptyData.INSTANCE;
        this.setChanged();
    }

    @Override
    @Nonnull
    public List<Component> getSplitButtonTooltip() {
        IData iData = this.data;
        if (iData instanceof PreSplitData) {
            PreSplitData psd = (PreSplitData)iData;
            return Lists.newArrayList((Object[])new Component[]{LCText.TOOLTIP_EJECTION_SPLIT_TRADER.get(psd.item.getHoverName())});
        }
        return super.getSplitButtonTooltip();
    }

    @Override
    @Nonnull
    public IconData getSplitButtonIcon() {
        IData iData = this.data;
        if (iData instanceof PreSplitData) {
            PreSplitData psd = (PreSplitData)iData;
            return IconData.of(psd.item);
        }
        return super.getSplitButtonIcon();
    }

    @Override
    public void splitContents() {
        IData iData = this.data;
        if (iData instanceof PreSplitData) {
            PreSplitData psd = (PreSplitData)iData;
            if (!psd.contents.isEmpty()) {
                LightmansCurrency.LogDebug("Splitting Trader Data!");
                TraderData trader = psd.getTrader(this);
                if (trader == null || trader.getState() != TraderState.EJECTED) {
                    return;
                }
                ItemStack item = psd.item.copy();
                item.remove(ModDataComponents.TRADER_ITEM_DATA);
                SimpleContainer contents = InventoryUtil.buildInventory(trader.getContents(item));
                OwnerData owner = new OwnerData(IClientTracker.forClient());
                owner.copyFrom(trader.getOwner());
                this.data = new SplitData(owner, new NonEmptyContainer((Container)contents), (Component)trader.getName());
                if (this.isServer()) {
                    TraderAPI.API.DeleteTrader(trader);
                }
            }
        }
    }

    private static class PreSplitData
    implements IData {
        private final long traderID;
        private final ItemStack item;
        private final Container contents;

        private PreSplitData(long traderID, @Nonnull ItemStack item) {
            this.traderID = traderID;
            this.item = item.copy();
            this.contents = InventoryUtil.buildInventory(this.item);
        }

        private TraderData getTrader(@Nonnull IClientTracker context) {
            return TraderAPI.API.GetTrader(context, this.traderID);
        }

        @Override
        @Nonnull
        public OwnerData getOwner(@Nonnull IClientTracker context) {
            TraderData trader = this.getTrader(context);
            return trader == null ? new OwnerData(context) : trader.getOwner();
        }

        @Override
        @Nonnull
        public Component getName(@Nonnull IClientTracker context) {
            TraderData trader = this.getTrader(context);
            return trader == null ? LCText.GUI_TRADER_DEFAULT_NAME.get(new Object[0]) : trader.getName();
        }

        @Override
        @Nonnull
        public Container getContents() {
            return this.contents;
        }

        @Override
        public boolean isEmpty(@Nonnull IClientTracker context) {
            TraderData trader = this.getTrader(context);
            return trader == null || trader.getState() != TraderState.EJECTED;
        }

        @Override
        public void saveAdditional(@Nonnull CompoundTag tag, @Nonnull HolderLookup.Provider lookup) {
            tag.putLong("TraderID", this.traderID);
            tag.put("Item", (Tag)InventoryUtil.saveItemNoLimits(this.item, lookup));
        }

        @Nonnull
        private static PreSplitData load(@Nonnull CompoundTag tag, @Nonnull HolderLookup.Provider lookup) {
            long traderID = tag.getLong("TraderID");
            ItemStack item = InventoryUtil.loadItemNoLimits(tag.getCompound("Item"), lookup);
            return new PreSplitData(traderID, item);
        }
    }

    private static interface IData {
        default public boolean isPreSplit() {
            return this instanceof PreSplitData;
        }

        default public boolean isSplit() {
            return this instanceof SplitData;
        }

        @Nonnull
        public OwnerData getOwner(@Nonnull IClientTracker var1);

        @Nonnull
        public Component getName(@Nonnull IClientTracker var1);

        @Nonnull
        public Container getContents();

        public boolean isEmpty(@Nonnull IClientTracker var1);

        public void saveAdditional(@Nonnull CompoundTag var1, @Nonnull HolderLookup.Provider var2);
    }

    private static class EmptyData
    implements IData {
        private static final EmptyData INSTANCE = new EmptyData();

        private EmptyData() {
        }

        @Override
        @Nonnull
        public OwnerData getOwner(@Nonnull IClientTracker context) {
            return new OwnerData(context);
        }

        @Override
        @Nonnull
        public Component getName(@Nonnull IClientTracker context) {
            return EasyText.literal("Null");
        }

        @Override
        @Nonnull
        public Container getContents() {
            return new SimpleContainer(1);
        }

        @Override
        public boolean isEmpty(@Nonnull IClientTracker context) {
            return true;
        }

        @Override
        public void saveAdditional(@Nonnull CompoundTag tag, @Nonnull HolderLookup.Provider lookup) {
            tag.putBoolean("Empty", true);
        }
    }

    private static class SplitData
    implements IData {
        private final OwnerData tempOwner;
        private OwnerData owner;
        private final NonEmptyContainer contents;
        private final Component name;

        private SplitData(@Nonnull OwnerData owner, @Nonnull NonEmptyContainer container, @Nonnull Component name) {
            this.tempOwner = owner;
            this.contents = container;
            this.name = name;
        }

        @Override
        @Nonnull
        public OwnerData getOwner(@Nonnull IClientTracker context) {
            if (this.owner == null) {
                this.owner = new OwnerData(context);
                this.owner.copyFrom(this.tempOwner);
            }
            return this.owner;
        }

        @Override
        @Nonnull
        public Component getName(@Nonnull IClientTracker context) {
            return this.name;
        }

        @Override
        @Nonnull
        public Container getContents() {
            return this.contents;
        }

        @Override
        public boolean isEmpty(@Nonnull IClientTracker context) {
            return false;
        }

        @Override
        public void saveAdditional(@Nonnull CompoundTag tag, @Nonnull HolderLookup.Provider lookup) {
            OwnerData o = this.owner == null ? this.tempOwner : this.owner;
            tag.put("Owner", (Tag)o.save(lookup));
            this.contents.save(tag, "Contents", lookup);
            tag.putString("Name", Component.Serializer.toJson((Component)this.name, (HolderLookup.Provider)lookup));
        }

        @Nonnull
        public static SplitData load(@Nonnull CompoundTag tag, @Nonnull HolderLookup.Provider lookup) {
            OwnerData owner = new OwnerData(IClientTracker.forClient());
            owner.load(tag.getCompound("Owner"), lookup);
            NonEmptyContainer contents = NonEmptyContainer.load(tag, "Contents", lookup);
            MutableComponent name = Component.Serializer.fromJson((String)tag.getString("Name"), (HolderLookup.Provider)lookup);
            return new SplitData(owner, contents, (Component)name);
        }
    }

    private static class Type
    extends EjectionDataType {
        private Type() {
        }

        @Override
        @Nonnull
        public EjectionData load(@Nonnull CompoundTag tag, @Nonnull HolderLookup.Provider lookup) {
            if (tag.getBoolean("Empty")) {
                return new TraderEjectionData(EmptyData.INSTANCE);
            }
            boolean split = tag.getBoolean("Split");
            IData data = split ? SplitData.load(tag, lookup) : PreSplitData.load(tag, lookup);
            return new TraderEjectionData(data);
        }
    }
}

