/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.items.cards;

import io.github.lightman314.lightmanscurrency.api.capability.money.MoneyHandler;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyView;
import io.github.lightman314.lightmanscurrency.common.core.ModDataComponents;
import javax.annotation.Nonnull;
import net.minecraft.world.item.ItemStack;

public class PrepaidCardMoneyHandler
extends MoneyHandler {
    private final ItemStack card;

    public PrepaidCardMoneyHandler(@Nonnull ItemStack card) {
        this.card = card;
    }

    @Nonnull
    private MoneyValue getCardMoney() {
        return (MoneyValue)this.card.getOrDefault(ModDataComponents.MONEY_VALUE, (Object)MoneyValue.empty());
    }

    private void setCardMoney(@Nonnull MoneyValue value) {
        this.card.set(ModDataComponents.MONEY_VALUE, (Object)value);
        if (value.isEmpty()) {
            this.card.setCount(0);
        }
    }

    @Override
    @Nonnull
    public MoneyValue insertMoney(@Nonnull MoneyValue insertAmount, boolean simulation) {
        return insertAmount;
    }

    @Override
    @Nonnull
    public MoneyValue extractMoney(@Nonnull MoneyValue extractAmount, boolean simulation) {
        MoneyValue value = this.getCardMoney();
        if (value.sameType(extractAmount)) {
            MoneyValue amountToTake;
            MoneyValue moneyValue = amountToTake = value.containsValue(extractAmount) ? extractAmount : value;
            if (!simulation) {
                this.setCardMoney(value.subtractValue(amountToTake));
            }
            return extractAmount.subtractValue(amountToTake);
        }
        return extractAmount;
    }

    @Override
    public boolean isMoneyTypeValid(@Nonnull MoneyValue value) {
        return this.getCardMoney().sameType(value);
    }

    @Override
    protected void collectStoredMoney(@Nonnull MoneyView.Builder builder) {
        builder.add(this.getCardMoney());
    }
}

