/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.items.data;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.capability.money.IMoneyHandler;
import io.github.lightman314.lightmanscurrency.api.money.MoneyAPI;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyView;
import io.github.lightman314.lightmanscurrency.api.money.value.holder.MoneyViewer;
import io.github.lightman314.lightmanscurrency.common.core.ModDataComponents;
import io.github.lightman314.lightmanscurrency.common.items.WalletItem;
import io.github.lightman314.lightmanscurrency.common.items.data.WalletData;
import io.github.lightman314.lightmanscurrency.common.menus.wallet.WalletMenuBase;
import io.github.lightman314.lightmanscurrency.common.util.IClientTracker;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public final class WalletDataWrapper
extends MoneyViewer {
    public static final WalletDataWrapper EMPTY = new WalletDataWrapper();
    private final ItemStack wallet;
    private final WalletItem item;
    Container contentCache = null;

    public boolean isForStack(@Nonnull ItemStack stack) {
        if (this.wallet == null && !WalletItem.isWallet(stack)) {
            return true;
        }
        return this.wallet == stack;
    }

    public int getContainerSize() {
        return WalletItem.InventorySize(this.wallet);
    }

    public int getBonusSlots() {
        return this.getData().getBonusSlots((Integer)this.wallet.getOrDefault(ModDataComponents.WALLET_UPGRADE_LIMIT, (Object)0));
    }

    private WalletDataWrapper() {
        this.wallet = null;
        this.item = null;
    }

    public WalletDataWrapper(@Nonnull ItemStack wallet) {
        this.wallet = wallet;
        this.item = (WalletItem)this.wallet.getItem();
        Container container = this.getContents();
        if (container.getContainerSize() != WalletItem.InventorySize(this.wallet)) {
            this.forceContainerSize(container);
        }
        this.contentCache = new SimpleContainer(WalletItem.InventorySize(this.wallet));
    }

    public boolean valid() {
        return this.wallet != null;
    }

    private WalletData getData() {
        if (this.wallet == null) {
            return WalletData.EMPTY;
        }
        if (!this.wallet.has(ModDataComponents.WALLET_DATA)) {
            this.wallet.set(ModDataComponents.WALLET_DATA, (Object)WalletData.createFor(this.wallet));
        }
        return (WalletData)this.wallet.get(ModDataComponents.WALLET_DATA);
    }

    public boolean getAutoExchange() {
        return WalletItem.CanExchange(this.item) && this.getData().autoExchange();
    }

    public void setAutoExchange(boolean autoExchange) {
        if (!this.valid()) {
            LightmansCurrency.LogError("WalletDataWrapper#setAutoExchange was called on a wallet wrapper that has not been intialized properly!");
            return;
        }
        this.wallet.set(ModDataComponents.WALLET_DATA, (Object)this.getData().withAutoExchange(autoExchange));
    }

    public Container getContents() {
        return InventoryUtil.buildInventory(this.getData().items());
    }

    public void setContents(@Nonnull Container contents, @Nullable LivingEntity owner) {
        if (!this.valid() && !contents.isEmpty()) {
            LightmansCurrency.LogError("WalletDataWrapper#setContents was called on a wallet wrapper that is not an actual wallet!");
            return;
        }
        if (contents.getContainerSize() != WalletItem.InventorySize(this.wallet)) {
            LightmansCurrency.LogWarning("WalletDataWrapper#setContents container size does not match the expected container size for this wallet.\nForcing container to match the wallets actual size!");
            contents = this.forceContainerSize(contents);
        }
        this.wallet.set(ModDataComponents.WALLET_DATA, (Object)this.getData().withItems(contents));
        if (owner != null) {
            WalletMenuBase.OnWalletUpdated((Entity)owner);
        }
    }

    private Container forceContainerSize(@Nonnull Container container) {
        SimpleContainer newContainer = new SimpleContainer(WalletItem.InventorySize(this.wallet));
        for (int i = 0; i < container.getContainerSize(); ++i) {
            if (i < newContainer.getContainerSize()) {
                newContainer.setItem(i, container.getItem(i).copy());
                continue;
            }
            ItemStack leftovers = InventoryUtil.TryPutItemStack((Container)newContainer, container.getItem(i));
            if (leftovers.isEmpty()) continue;
            LightmansCurrency.LogWarning("Lost " + leftovers.getCount() + "x " + String.valueOf(BuiltInRegistries.ITEM.getKey((Object)leftovers.getItem())) + " when shrinking Wallet Contents to fit size limits!");
        }
        return newContainer;
    }

    @Override
    protected void collectStoredMoney(@Nonnull MoneyView.Builder builder) {
        this.contentCache = this.getContents();
        IMoneyHandler handler = MoneyAPI.API.GetContainersMoneyHandler(this.contentCache, s -> {}, IClientTracker.forClient());
        builder.merge(handler.getStoredMoney());
    }
}

